/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.eval;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleConstraint;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.system.G;

class ShapeEvalTripleConstraint {
    ShapeEvalTripleConstraint() {
    }

    static boolean matchesCardinalityTC(ValidationContext vCxt, Set<Triple> matchables, Node node, TripleConstraint tripleConstraint, Set<Node> extras) {
        Node predicate = tripleConstraint.getPredicate();
        if (tripleConstraint.reverse()) {
            matchables = G.find(vCxt.getData(), null, predicate, node).toSet();
        } else if (!matchables.stream().allMatch(t2 -> predicate.equals(t2.getPredicate()))) {
            return false;
        }
        Set<Triple> triples = StreamOps.toSet(matchables.stream().filter(t2 -> predicate.equals(t2.getPredicate())));
        int min2 = tripleConstraint.min();
        int max2 = tripleConstraint.max();
        ShapeExpression shExpr = tripleConstraint.getShapeExpression();
        Set positive = triples.stream().filter(t2 -> {
            Node v = tripleConstraint.reverse() ? t2.getSubject() : t2.getObject();
            return shExpr.satisfies(vCxt, v);
        }).collect(Collectors.toSet());
        int N2 = positive.size();
        if (min2 >= 0 && N2 < min2) {
            vCxt.reportEntry(new ReportItem("Cardinality violation (min=" + min2 + "): " + N2, null));
            return false;
        }
        if (!(extras != null && extras.contains(predicate) || positive.size() == triples.size())) {
            return false;
        }
        if (max2 >= 0 && N2 > max2) {
            vCxt.reportEntry(new ReportItem("Cardinality violation (max=" + max2 + "): " + N2, null));
            return false;
        }
        boolean b = tripleConstraint.testSemanticActions(vCxt, matchables);
        return b;
    }
}

