/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.GraphRDFS;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.rdfs.setup.MatchVocabRDFS;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphIncRDFS
extends GraphRDFS {
    private final MatchVocabRDFS vocab;
    private Set<Triple> extra;

    public GraphIncRDFS(Graph graph, ConfigRDFS<Node> setup) {
        super(graph, setup);
        this.vocab = new MatchVocabRDFS(setup);
        this.extra = StreamOps.toSet(graph.stream(null, ConstRDFS.rdfType, null).map(Triple::getObject).filter(type -> !setup.getSubClassHierarchy().keySet().contains(type)).map(type -> Triple.create(type, ConstRDFS.rdfsSubClassOf, type)));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s2, Node p, Node o) {
        Stream<Triple> stream1 = super.stream(s2, p, o);
        Stream<Triple> stream2 = this.vocab.match(s2, p, o);
        Stream<Triple> stream = Stream.concat(stream1, stream2);
        if (this.wildcard(p) || ConstRDFS.rdfsSubClassOf.equals(p)) {
            Stream<Triple> stream3 = this.extras(s2, p, o);
            stream = Stream.concat(stream, stream3);
        }
        stream = stream.distinct();
        WrappedIterator<Triple> iter = WrappedIterator.ofStream(stream);
        return iter;
    }

    private Stream<Triple> extras(Node s2, Node p, Node o) {
        return this.extra.stream().filter(t2 -> this.matchTerm(t2.getSubject(), s2) && this.matchTerm(t2.getPredicate(), p) && this.matchTerm(t2.getObject(), o));
    }

    private boolean matchTerm(Node data, Node pattern) {
        if (this.wildcard(pattern)) {
            return true;
        }
        return pattern.equals(data);
    }

    private boolean wildcard(Node n) {
        return n == null || Node.ANY.equals(n);
    }
}

