/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.system;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.system.PrefixMappingChanges;
import org.apache.jena.rdfpatch.system.TransactionHandlerMonitor;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.GraphWrapper;

public class GraphChanges
extends GraphWrapper {
    private final RDFChanges changes;
    protected final Node graphName;
    private final PrefixMapping prefixMapping;
    private final TransactionHandler transactionHandler;

    public GraphChanges(Graph graph, RDFChanges changes) {
        this(graph, null, changes);
    }

    public GraphChanges(Graph graph, Node graphName, RDFChanges changes) {
        super(graph);
        this.graphName = graphName;
        this.changes = changes;
        this.prefixMapping = new PrefixMappingChanges(graph, graphName, changes);
        this.transactionHandler = new TransactionHandlerMonitor(graph.getTransactionHandler(), changes);
    }

    @Override
    public void add(Triple t2) {
        this.changes.add(this.graphName, t2.getSubject(), t2.getPredicate(), t2.getObject());
        super.add(t2);
    }

    @Override
    public void delete(Triple t2) {
        this.changes.delete(this.graphName, t2.getSubject(), t2.getPredicate(), t2.getObject());
        super.delete(t2);
    }

    @Override
    public void clear() {
        this.remove(Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    @Override
    public void remove(Node s2, Node p, Node o) {
        GraphUtil.remove(this, s2, p, o);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }
}

