/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecBuilderAdapter;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecBuilderAdapter;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateRequest;

public class RDFLinkAdapter
implements RDFLink {
    private final RDFConnection conn;

    public static RDFLink adapt(RDFConnection conn) {
        if (conn instanceof RDFConnectionAdapter) {
            RDFConnectionAdapter adapter = (RDFConnectionAdapter)conn;
            return adapter.getLink();
        }
        return new RDFLinkAdapter(conn);
    }

    protected RDFConnection getConnection() {
        return this.conn;
    }

    public RDFLinkAdapter(RDFConnection conn) {
        this.conn = conn;
    }

    @Override
    public void begin(TxnType type) {
        this.conn.begin(type);
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.conn.begin(readWrite);
    }

    @Override
    public boolean promote(Transactional.Promote mode) {
        return this.conn.promote(mode);
    }

    @Override
    public void commit() {
        this.conn.commit();
    }

    @Override
    public void abort() {
        this.conn.abort();
    }

    @Override
    public void end() {
        this.conn.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.conn.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.conn.transactionType();
    }

    @Override
    public boolean isInTransaction() {
        return this.conn.isInTransaction();
    }

    @Override
    public DatasetGraph getDataset() {
        Dataset ds = this.conn.fetchDataset();
        return ds == null ? null : ds.asDatasetGraph();
    }

    @Override
    public QueryExec query(Query query2) {
        return QueryExec.adapt(this.conn.query(query2));
    }

    @Override
    public QueryExec query(String queryString) {
        return QueryExec.adapt(this.conn.query(queryString));
    }

    @Override
    public QueryExecBuilder newQuery() {
        QueryExecutionBuilder qeb = this.conn.newQuery();
        return QueryExecBuilderAdapter.adapt(qeb);
    }

    @Override
    public UpdateExecBuilder newUpdate() {
        UpdateExecutionBuilder ueb = this.conn.newUpdate();
        return UpdateExecBuilderAdapter.adapt(ueb);
    }

    @Override
    public void update(UpdateRequest update2) {
        this.conn.update(update2);
    }

    @Override
    public void update(String update2) {
        this.conn.update(update2);
    }

    @Override
    public Graph get() {
        Model m4 = this.conn.fetch();
        if (m4 == null) {
            return null;
        }
        return m4.getGraph();
    }

    private static String uri(Node node) {
        return node == null ? null : node.getURI();
    }

    @Override
    public Graph get(Node graphName) {
        Model m4 = this.conn.fetch(RDFLinkAdapter.uri(graphName));
        if (m4 == null) {
            return null;
        }
        return m4.getGraph();
    }

    @Override
    public void load(String file) {
        this.conn.load(file);
    }

    @Override
    public void load(Node graphName, String file) {
        this.conn.load(RDFLinkAdapter.uri(graphName), file);
    }

    @Override
    public void load(Graph graph) {
        this.conn.load(ModelFactory.createModelForGraph(graph));
    }

    @Override
    public void load(Node graphName, Graph graph) {
        this.conn.load(RDFLinkAdapter.uri(graphName), ModelFactory.createModelForGraph(graph));
    }

    @Override
    public void put(String file) {
        this.conn.put(file);
    }

    @Override
    public void put(Node graphName, String file) {
        this.conn.put(RDFLinkAdapter.uri(graphName), file);
    }

    @Override
    public void put(Graph graph) {
        this.conn.put(ModelFactory.createModelForGraph(graph));
    }

    @Override
    public void put(Node graphName, Graph graph) {
        this.conn.put(RDFLinkAdapter.uri(graphName), ModelFactory.createModelForGraph(graph));
    }

    @Override
    public void delete(Node graphName) {
        this.conn.delete(RDFLinkAdapter.uri(graphName));
    }

    @Override
    public void delete() {
        this.conn.delete();
    }

    @Override
    public void loadDataset(String file) {
        this.conn.loadDataset(file);
    }

    @Override
    public void loadDataset(DatasetGraph dataset) {
        this.conn.loadDataset(DatasetFactory.wrap(dataset));
    }

    @Override
    public void putDataset(String file) {
        this.conn.putDataset(file);
    }

    @Override
    public void putDataset(DatasetGraph dataset) {
        this.conn.putDataset(DatasetFactory.wrap(dataset));
    }

    @Override
    public void clearDataset() {
        DatasetFactory.wrap(DatasetGraphZero.create());
    }

    @Override
    public boolean isClosed() {
        return this.conn.isClosed();
    }

    @Override
    public void close() {
        this.conn.close();
    }
}

