/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Iterator;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Alt;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.SeqIndexBoundsException;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ContainerImpl;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.SeqNodeIteratorImpl;
import org.apache.jena.vocabulary.RDF;

public class SeqImpl
extends ContainerImpl
implements Seq {
    public static final Implementation factory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return true;
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            return new SeqImpl(n, eg);
        }
    };

    public SeqImpl(ModelCom model) {
        super(model);
    }

    public SeqImpl(String uri, ModelCom model) {
        super(uri, model);
    }

    public SeqImpl(Resource r, ModelCom m4) {
        super(r, m4);
    }

    public SeqImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public Resource getResource(int index) {
        return this.getRequiredProperty(RDF.li(index)).getResource();
    }

    @Override
    public Literal getLiteral(int index) {
        return this.getRequiredProperty(RDF.li(index)).getLiteral();
    }

    @Override
    public RDFNode getObject(int index) {
        return this.getRequiredProperty(RDF.li(index)).getObject();
    }

    @Override
    public boolean getBoolean(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getBoolean();
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getByte();
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getShort();
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getInt();
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getLong();
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getChar();
    }

    @Override
    public float getFloat(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getFloat();
    }

    @Override
    public double getDouble(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getDouble();
    }

    @Override
    public String getString(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getString();
    }

    @Override
    public String getLanguage(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getLanguage();
    }

    @Override
    public Bag getBag(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getBag();
    }

    @Override
    public Alt getAlt(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getAlt();
    }

    @Override
    public Seq getSeq(int index) {
        this.checkIndex(index);
        return this.getRequiredProperty(RDF.li(index)).getSeq();
    }

    @Override
    public Seq set(int index, RDFNode o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    @Override
    public Seq set(int index, boolean o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, long o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, float o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, double o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, char o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeLiteralObject(o);
        return this;
    }

    @Override
    public Seq set(int index, String o) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o);
        return this;
    }

    @Override
    public Seq set(int index, String o, String l) {
        this.checkIndex(index);
        this.getRequiredProperty(RDF.li(index)).changeObject(o, l);
        return this;
    }

    @Override
    public Seq set(int index, Object o) {
        this.checkIndex(index);
        Statement s2 = this.getRequiredProperty(RDF.li(index));
        Model m4 = s2.getModel();
        Statement s22 = m4.createLiteralStatement(s2.getSubject(), s2.getPredicate(), o);
        s2.getModel().remove(s2);
        s2.getModel().add(s22);
        return this;
    }

    @Override
    public Seq add(int index, boolean o) {
        return this.add(index, this.getModel().createTypedLiteral(o));
    }

    @Override
    public Seq add(int index, long o) {
        return this.add(index, this.getModel().createTypedLiteral(o));
    }

    @Override
    public Seq add(int index, char o) {
        return this.add(index, this.getModel().createTypedLiteral(o));
    }

    @Override
    public Seq add(int index, float o) {
        return this.add(index, this.getModel().createTypedLiteral(o));
    }

    @Override
    public Seq add(int index, double o) {
        return this.add(index, this.getModel().createTypedLiteral(o));
    }

    @Override
    public Seq add(int index, Object o) {
        return this.add(index, this.getModel().createTypedLiteral(o));
    }

    @Override
    public Seq add(int index, String o) {
        return this.add(index, o, "");
    }

    @Override
    public Seq add(int index, String o, String l) {
        return this.add(index, this.literal(o, l));
    }

    @Override
    public Seq add(int index, RDFNode o) {
        int size = this.size();
        this.checkIndex(index, size + 1);
        this.shiftUp(index, size);
        this.addProperty(RDF.li(index), o);
        return this;
    }

    @Override
    public NodeIterator iterator() {
        return this.listContainerMembers();
    }

    @Override
    protected NodeIterator createIterator(Iterator<Statement> iter) {
        return new SeqNodeIteratorImpl(iter, this);
    }

    @Override
    public Container remove(Statement s2) {
        this.getModel().remove(s2);
        this.shiftDown(s2.getPredicate().getOrdinal() + 1, this.size() + 1);
        return this;
    }

    @Override
    public Seq remove(int index) {
        this.getRequiredProperty(RDF.li(index)).remove();
        this.shiftDown(index + 1, this.size() + 1);
        return this;
    }

    @Override
    public Container remove(int index, RDFNode o) {
        return this.remove(this.getModel().createStatement((Resource)this, RDF.li(index), o).remove());
    }

    @Override
    public int indexOf(RDFNode o) {
        return this.containerIndexOf(o);
    }

    @Override
    public int indexOf(boolean o) {
        return this.indexOf(this.getModel().createTypedLiteral(o));
    }

    @Override
    public int indexOf(long o) {
        return this.indexOf(this.getModel().createTypedLiteral(o));
    }

    @Override
    public int indexOf(char o) {
        return this.indexOf(this.getModel().createTypedLiteral(o));
    }

    @Override
    public int indexOf(float o) {
        return this.indexOf(this.getModel().createTypedLiteral(o));
    }

    @Override
    public int indexOf(double o) {
        return this.indexOf(this.getModel().createTypedLiteral(o));
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(this.getModel().createTypedLiteral(o));
    }

    @Override
    public int indexOf(String o) {
        return this.indexOf(o, "");
    }

    @Override
    public int indexOf(String o, String l) {
        return this.indexOf(this.literal(o, l));
    }

    private Literal literal(String s2, String lang) {
        return new LiteralImpl(NodeFactory.createLiteralLang(s2, lang), this.getModelCom());
    }

    protected void shiftUp(int start, int finish) {
        Statement stmt = null;
        for (int i = finish; i >= start; --i) {
            stmt = this.getRequiredProperty(RDF.li(i));
            this.getModel().remove(stmt);
            this.addProperty(RDF.li(i + 1), stmt.getObject());
        }
    }

    protected void shiftDown(int start, int finish) {
        for (int i = start; i <= finish; ++i) {
            Statement stmt = this.getRequiredProperty(RDF.li(i));
            stmt.remove();
            this.addProperty(RDF.li(i - 1), stmt.getObject());
        }
    }

    protected void checkIndex(int index) {
        this.checkIndex(index, this.size());
    }

    protected void checkIndex(int index, int max2) {
        if (1 > index || index > max2) {
            throw new SeqIndexBoundsException(max2, index);
        }
    }
}

