/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.impl.ModelCom;

public class ModelListenerAdapter
implements GraphListener {
    protected ModelCom m;
    protected ModelChangedListener L;

    public ModelListenerAdapter(ModelCom m4, ModelChangedListener L) {
        this.m = m4;
        this.L = L;
    }

    @Override
    public void notifyAddArray(Graph graph, Triple[] triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteArray(Graph g2, Triple[] triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyAddTriple(Graph g2, Triple t2) {
        this.L.addedStatement(this.m.asStatement(t2));
    }

    @Override
    public void notifyAddList(Graph g2, List<Triple> triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyAddIterator(Graph g2, Iterator<Triple> it) {
        this.L.addedStatements(this.m.asStatements(it));
    }

    @Override
    public void notifyAddGraph(Graph g2, Graph added) {
        this.L.addedStatements(this.m.asModel(added));
    }

    @Override
    public void notifyDeleteIterator(Graph g2, Iterator<Triple> it) {
        this.L.removedStatements(this.m.asStatements(it));
    }

    @Override
    public void notifyDeleteTriple(Graph g2, Triple t2) {
        this.L.removedStatement(this.m.asStatement(t2));
    }

    public void notifyAddIterator(Graph g2, List<Triple> triples) {
        this.L.addedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteList(Graph g2, List<Triple> triples) {
        this.L.removedStatements(this.m.asStatements(triples));
    }

    @Override
    public void notifyDeleteGraph(Graph g2, Graph removed) {
        this.L.removedStatements(this.m.asModel(removed));
    }

    @Override
    public void notifyEvent(Graph g2, Object event) {
        this.L.notifyEvent(this.m, event);
    }

    public int hashCode() {
        return Objects.hash(this.L, this.m);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModelListenerAdapter)) {
            return false;
        }
        ModelListenerAdapter other = (ModelListenerAdapter)obj;
        return Objects.equals(this.L, other.L) && Objects.equals(this.m, other.m);
    }
}

