/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.changes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.query.text.changes.TextDatasetChanges;
import org.apache.jena.query.text.changes.TextQuadAction;
import org.apache.jena.sparql.core.Quad;

public abstract class ChangesBatched
implements TextDatasetChanges {
    private TextQuadAction currentAction = null;
    private Node currentSubject = null;
    private Node currentGraph = null;
    private List<Quad> batchQuads = null;
    private boolean mergeBlankNodes = false;

    protected ChangesBatched() {
        this(false);
    }

    protected ChangesBatched(boolean mergeBNodes) {
        this.mergeBlankNodes = mergeBNodes;
    }

    @Override
    public final void start() {
        this.startBatched();
        this.startBatch();
    }

    @Override
    public final void finish() {
        this.finishBatch();
        this.finishBatched();
    }

    @Override
    public final void reset() {
    }

    @Override
    public void change(TextQuadAction qaction, Node g2, Node s2, Node p, Node o) {
        if (this.mergeBlankNodes && s2.isBlank()) {
            if (this.batchQuads == null) {
                this.startBatch();
            }
        } else if (!(Objects.equals((Object)this.currentAction, (Object)qaction) && Objects.equals(this.currentGraph, g2) && Objects.equals(this.currentSubject, s2))) {
            this.finishBatch();
            this.startBatch();
            this.currentAction = qaction;
            this.currentGraph = g2;
            this.currentSubject = s2;
        }
        this.batchQuads.add(new Quad(g2, s2, p, o));
    }

    private void startBatch() {
        if (this.batchQuads == null) {
            this.batchQuads = new ArrayList<Quad>();
        }
    }

    protected void finishBatch() {
        if (this.batchQuads == null || this.batchQuads.size() == 0) {
            return;
        }
        this.dispatch(this.currentAction, this.batchQuads);
        this.batchQuads = null;
    }

    protected abstract void dispatch(TextQuadAction var1, List<Quad> var2);

    protected abstract void startBatched();

    protected abstract void finishBatched();
}

