/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sparql.util.TranslationTable;

public class Syntax
extends Symbol {
    public static final Syntax syntaxSPARQL_10 = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_10");
    public static final Syntax syntaxSPARQL_11 = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_11");
    public static final Syntax syntaxSPARQL_12 = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_12");
    public static final Syntax syntaxARQ = new Syntax("http://jena.hpl.hp.com/2003/07/query/ARQ");
    public static final Syntax syntaxAlgebra = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL_Algebra");
    public static Syntax defaultSyntax;
    public static Syntax defaultQuerySyntax;
    public static Syntax defaultUpdateSyntax;
    public static final Syntax syntaxSPARQL;
    public static TranslationTable<Syntax> querySyntaxNames;
    public static TranslationTable<Syntax> updateSyntaxNames;

    protected Syntax(String s2) {
        super(s2);
    }

    protected Syntax(Syntax s2) {
        super(s2);
    }

    public static Syntax make(String uri) {
        if (uri == null) {
            return null;
        }
        Symbol sym = Symbol.create(uri);
        if (sym.equals(syntaxARQ)) {
            return syntaxARQ;
        }
        if (sym.equals(syntaxSPARQL)) {
            return syntaxSPARQL;
        }
        if (sym.equals(syntaxSPARQL_10)) {
            return syntaxSPARQL_10;
        }
        if (sym.equals(syntaxSPARQL_11)) {
            return syntaxSPARQL_11;
        }
        if (sym.equals(syntaxSPARQL_11)) {
            return syntaxSPARQL_12;
        }
        if (sym.equals(syntaxAlgebra)) {
            return syntaxAlgebra;
        }
        return null;
    }

    public static Syntax guessFileSyntax(String url) {
        return Syntax.guessFileSyntax(url, defaultQuerySyntax);
    }

    public static Syntax guessFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".arq")) {
            return syntaxARQ;
        }
        if (url.endsWith(".rq")) {
            return defaultQuerySyntax;
        }
        if (url.endsWith(".aru")) {
            return syntaxARQ;
        }
        if (url.endsWith(".ru")) {
            return defaultUpdateSyntax;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax guessQueryFileSyntax(String url) {
        return Syntax.guessFileSyntax(url, defaultQuerySyntax);
    }

    public static Syntax guessQueryFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".arq")) {
            return syntaxARQ;
        }
        if (url.endsWith(".rq")) {
            return defaultQuerySyntax;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax guessUpdateFileSyntax(String url) {
        return Syntax.guessUpdateFileSyntax(url, defaultUpdateSyntax);
    }

    public static Syntax guessUpdateFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".aru")) {
            return syntaxARQ;
        }
        if (url.endsWith(".ru")) {
            return defaultQuerySyntax;
        }
        if (url.endsWith(".sse")) {
            return syntaxAlgebra;
        }
        return defaultSyntax;
    }

    public static Syntax lookup(String s2) {
        return querySyntaxNames.lookup(s2);
    }

    static {
        defaultQuerySyntax = defaultSyntax = syntaxARQ;
        defaultUpdateSyntax = defaultSyntax;
        syntaxSPARQL = syntaxSPARQL_12;
        querySyntaxNames = new TranslationTable(true);
        querySyntaxNames.put("sparql", syntaxSPARQL);
        querySyntaxNames.put("sparql10", syntaxSPARQL_10);
        querySyntaxNames.put("sparql_10", syntaxSPARQL_10);
        querySyntaxNames.put("sparql11", syntaxSPARQL_11);
        querySyntaxNames.put("sparql_11", syntaxSPARQL_11);
        querySyntaxNames.put("sparql12", syntaxSPARQL_12);
        querySyntaxNames.put("sparql_12", syntaxSPARQL_12);
        querySyntaxNames.put("arq", syntaxARQ);
        querySyntaxNames.put("alg", syntaxAlgebra);
        querySyntaxNames.put("op", syntaxAlgebra);
        updateSyntaxNames = new TranslationTable(true);
        updateSyntaxNames.put("sparql", syntaxSPARQL);
        updateSyntaxNames.put("sparql_11", syntaxSPARQL_11);
        updateSyntaxNames.put("sparql_12", syntaxSPARQL_11);
        updateSyntaxNames.put("arq", syntaxARQ);
    }
}

