/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Objects;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.server.Validator;

public class ValidString {
    public final String string;
    public final Validator validator;

    public static ValidString create(String string, Validator validator) {
        boolean isValid = validator.validator.apply(string);
        if (!isValid) {
            throw new FusekiConfigException("String '" + string + "' not valid as '" + validator.getPolicy() + "'");
        }
        return new ValidString(string, validator);
    }

    private ValidString(String string, Validator validator) {
        this.string = string;
        this.validator = validator;
    }

    public String toString() {
        return "Valid[" + this.string + "]";
    }

    public int hashCode() {
        return Objects.hash(this.string, this.validator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidString other = (ValidString)obj;
        return Objects.equals(this.string, other.string) && Objects.equals(this.validator, other.validator);
    }
}

