/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.build;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.build.FusekiPrefixes;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDFS;

class BuildLib {
    private BuildLib() {
    }

    static ResultSet query(String string, Model m4) {
        return BuildLib.query(string, m4, null, null);
    }

    static RDFNode queryOne(String string, Model m4, String varname) {
        ResultSet rs = BuildLib.query(string, m4);
        return BuildLib.getExactlyOne(rs, varname);
    }

    private static RDFNode getExactlyOne(ResultSet rs, String varname) {
        if (!rs.hasNext()) {
            return null;
        }
        QuerySolution qs = rs.next();
        if (rs.hasNext()) {
            return null;
        }
        return qs.get(varname);
    }

    static ResultSet query(String string, Dataset ds) {
        return BuildLib.query(string, ds, null, null);
    }

    static ResultSet query(String string, Model m4, String varName, RDFNode value) {
        Query query2 = QueryFactory.create(FusekiPrefixes.PREFIXES + string);
        QuerySolutionMap initValues = null;
        if (varName != null && value != null) {
            initValues = BuildLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecution.create().query(query2).model(m4).initialBinding(initValues).build();){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults(qExec.execSelect());
            return resultSetRewindable;
        }
    }

    static ResultSet query(String string, Dataset ds, String varName, RDFNode value) {
        Query query2 = QueryFactory.create(FusekiPrefixes.PREFIXES + string);
        QuerySolutionMap initValues = null;
        if (varName != null && value != null) {
            initValues = BuildLib.querySolution(varName, value);
        }
        try (QueryExecution qExec = QueryExecution.dataset(ds).query(query2).substitution(initValues).build();){
            ResultSetRewindable resultSetRewindable = ResultSetFactory.copyResults(qExec.execSelect());
            return resultSetRewindable;
        }
    }

    private static QuerySolutionMap querySolution(String varName, RDFNode value) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        BuildLib.querySolution(qsm, varName, value);
        return qsm;
    }

    static QuerySolutionMap querySolution(QuerySolutionMap qsm, String varName, RDFNode value) {
        qsm.add(varName, value);
        return qsm;
    }

    static RDFNode getOne(Resource svc, Property property) {
        ResultSet rs = BuildLib.query("SELECT * { ?svc <" + property.getURI() + "> ?x}", svc.getModel(), "svc", (RDFNode)svc);
        if (!rs.hasNext()) {
            throw new FusekiConfigException("No property '" + property + "' for service " + BuildLib.nodeLabel(svc));
        }
        RDFNode x = rs.next().get("x");
        if (rs.hasNext()) {
            throw new FusekiConfigException("Multiple properties '" + property + "' for service " + BuildLib.nodeLabel(svc));
        }
        return x;
    }

    static Collection<RDFNode> getAll(Resource resource, String property) {
        ResultSet rs = BuildLib.query("SELECT * { ?subject " + property + " ?x}", resource.getModel(), "subject", (RDFNode)resource);
        if (!rs.hasNext()) {
            return null;
        }
        ArrayList<RDFNode> results = new ArrayList<RDFNode>();
        rs.forEachRemaining((Consumer<? super QuerySolution>)((Consumer<QuerySolution>)qs -> {
            RDFNode n = qs.get("x");
            try {
                RDFList list = n.as(RDFList.class);
                results.addAll(list.asJavaList());
            }
            catch (JenaException x) {
                results.add(n);
            }
        }));
        return results;
    }

    static String nodeLabel(RDFNode n) {
        if (n == null) {
            return "<null>";
        }
        if (n instanceof Resource) {
            Resource r = (Resource)n;
            return BuildLib.strForResource(r);
        }
        Literal lit = (Literal)n;
        return lit.getLexicalForm();
    }

    static String strForResource(Resource r) {
        return BuildLib.strForResource(r, r.getModel());
    }

    static String strForResource(Resource r, PrefixMapping pm) {
        RDFNode n;
        if (r == null) {
            return "NULL ";
        }
        if (r.hasProperty(RDFS.label) && (n = r.getProperty(RDFS.label).getObject()) instanceof Literal) {
            Literal literal = (Literal)n;
            return literal.getString();
        }
        if (r.isAnon()) {
            return "<<blank node>>";
        }
        if (pm == null) {
            pm = r.getModel();
        }
        return BuildLib.strForURI(r.getURI(), pm);
    }

    static String strForURI(String uri, PrefixMapping pm) {
        String x;
        if (pm != null && !(x = pm.shortForm(uri)).equals(uri)) {
            return x;
        }
        return "<" + uri + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RDFNode getZeroOrOne(Resource ep, Property property) {
        try (StmtIterator iter = ep.listProperties(property);){
            if (!iter.hasNext()) {
                RDFNode rDFNode = null;
                return rDFNode;
            }
            RDFNode x = ((Statement)iter.next()).getObject();
            if (iter.hasNext()) {
                throw new FusekiConfigException("Multiple triples for " + NodeFmtLib.displayStr(ep) + " " + NodeFmtLib.displayStr(property));
            }
            RDFNode rDFNode = x;
            return rDFNode;
        }
    }

    static Pair<Operation, ActionService> loadOperationActionService(RDFNode implementation) {
        String classURI = implementation.isLiteral() ? implementation.asLiteral().getLexicalForm() : ((Resource)implementation).getURI();
        String javaScheme = "java:";
        String fileScheme = "file:";
        String scheme = null;
        if (classURI.startsWith(javaScheme)) {
            scheme = javaScheme;
        } else if (classURI.startsWith(fileScheme)) {
            scheme = fileScheme;
        } else {
            Fuseki.configLog.error("Class to load is not 'java:' or 'file:': " + classURI);
            throw new FusekiConfigException("Not a 'java:' or 'file:' class reference: " + classURI);
        }
        String className = classURI.substring(scheme.length());
        ActionService action = null;
        try {
            Class<?> cls;
            if (Objects.equals(scheme, fileScheme)) {
                try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new URL(classURI)});){
                    cls = Class.forName(className, true, urlClassLoader);
                }
            } else {
                cls = Class.forName(className);
            }
            Constructor<?> x = cls.getConstructor(new Class[0]);
            action = (ActionService)x.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            throw new FusekiConfigException("Class not found: " + className);
        }
        catch (Exception ex) {
            throw new FusekiConfigException("Can't create object from " + className);
        }
        Operation op = Operation.alloc(NodeFactory.createBlankNode(), classURI, classURI);
        return Pair.create(op, action);
    }
}

