/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationDocumentation;
import java.io.IOException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;

public class DefaultApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final DefaultApacheHttpClientObservationConvention INSTANCE = new DefaultApacheHttpClientObservationConvention();
    private static final KeyValue METHOD_UNKNOWN = KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD, "UNKNOWN");
    private static final KeyValue URI_UNKNOWN = KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI, "UNKNOWN");
    private static final KeyValue STATUS_IO_ERROR = KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS, "IO_ERROR");
    private static final KeyValue STATUS_CLIENT_ERROR = KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS, "CLIENT_ERROR");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.EXCEPTION, "none");

    protected DefaultApacheHttpClientObservationConvention() {
    }

    @Override
    public String getName() {
        return "httpcomponents.httpclient.request";
    }

    @Override
    public String getContextualName(ApacheHttpClientContext context2) {
        HttpRequest request = (HttpRequest)context2.getCarrier();
        String methodName = "UNKNOWN";
        if (request != null && request.getMethod() != null) {
            methodName = request.getMethod();
        }
        return "HTTP " + methodName;
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context2) {
        return KeyValues.of(this.exception(context2), this.method(context2), this.outcome(context2), this.status(context2), this.targetHost(context2), this.targetPort(context2), this.targetScheme(context2), this.uri(context2));
    }

    protected KeyValue exception(ApacheHttpClientContext context2) {
        Throwable error = context2.getError();
        if (error != null) {
            return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.EXCEPTION, error.getClass().getSimpleName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue method(ApacheHttpClientContext context2) {
        HttpRequest request = (HttpRequest)context2.getCarrier();
        if (request == null || request.getMethod() == null) {
            return METHOD_UNKNOWN;
        }
        return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD.withValue(request.getMethod());
    }

    protected KeyValue outcome(ApacheHttpClientContext context2) {
        HttpResponse response = (HttpResponse)context2.getResponse();
        if (response == null) {
            return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME, Outcome.UNKNOWN.name());
        }
        return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME, Outcome.forStatus(response.getCode()).name());
    }

    protected KeyValue status(ApacheHttpClientContext context2) {
        Throwable error = context2.getError();
        HttpResponse response = (HttpResponse)context2.getResponse();
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return STATUS_IO_ERROR;
        }
        if (response == null) {
            return STATUS_CLIENT_ERROR;
        }
        return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS, Integer.toString(response.getCode()));
    }

    protected KeyValue targetHost(ApacheHttpClientContext context2) {
        RouteInfo httpRoute = context2.getHttpClientContext().getHttpRoute();
        if (httpRoute != null) {
            return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_HOST, httpRoute.getTargetHost().getHostName());
        }
        return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_HOST, "UNKNOWN");
    }

    protected KeyValue targetPort(ApacheHttpClientContext context2) {
        Object routeAttribute = context2.getHttpClientContext().getAttribute("http.route");
        if (routeAttribute instanceof HttpRoute) {
            int port = ((HttpRoute)routeAttribute).getTargetHost().getPort();
            return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_PORT, String.valueOf(port));
        }
        return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_PORT, "UNKNOWN");
    }

    protected KeyValue targetScheme(ApacheHttpClientContext context2) {
        Object routeAttribute = context2.getHttpClientContext().getAttribute("http.route");
        if (routeAttribute instanceof HttpRoute) {
            return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_SCHEME, ((HttpRoute)routeAttribute).getTargetHost().getSchemeName());
        }
        return KeyValue.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_SCHEME, "UNKNOWN");
    }

    protected KeyValue uri(ApacheHttpClientContext context2) {
        HttpClientContext clientContext = context2.getHttpClientContext();
        String uriTemplate = (String)clientContext.getAttribute("micrometer.uri.template");
        if (uriTemplate != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(uriTemplate);
        }
        if (context2.getCarrier() != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(context2.getUriMapper().apply((HttpRequest)context2.getCarrier()));
        }
        return URI_UNKNOWN;
    }

    @Deprecated
    Outcome getStatusOutcome(@Nullable HttpResponse response) {
        return response != null ? Outcome.forStatus(response.getCode()) : Outcome.UNKNOWN;
    }

    @Deprecated
    String getStatusValue(@Nullable HttpResponse response, Throwable error) {
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return "IO_ERROR";
        }
        return response != null ? Integer.toString(response.getCode()) : "CLIENT_ERROR";
    }

    @Deprecated
    String getMethodString(@Nullable HttpRequest request) {
        return request != null && request.getMethod() != null ? request.getMethod() : "UNKNOWN";
    }
}

