/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModEngine;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModQueryOut;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.QueryCheckException;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.QueryOutputUtils;
import org.apache.jena.sparql.util.QueryUtils;

public class qparse
extends CmdARQ {
    protected ModQueryIn modQuery = new ModQueryIn(Syntax.syntaxARQ);
    protected ModQueryOut modOutput = new ModQueryOut();
    protected ModEngine modEngine = new ModEngine();
    protected final ArgDecl argDeclPrint = new ArgDecl(true, "print");
    protected final ArgDecl argDeclOpt = new ArgDecl(false, "opt", "optimize");
    protected final ArgDecl argDeclExplain = new ArgDecl(false, "explain");
    protected final ArgDecl argDeclFixup = new ArgDecl(false, "fixup");
    protected boolean printNone = false;
    protected boolean printQuery = false;
    protected boolean printOp = false;
    protected boolean printOpt = false;
    protected boolean printQuad = false;
    protected boolean printQuadOpt = false;
    protected boolean printPlan = false;
    static String usage = qparse.class.getName() + " [--in syntax] [--out syntax] [--print=FORM] [\"query\"] | --query <file>";
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String ... argv) {
        new qparse(argv).mainRun();
    }

    public qparse(String[] argv) {
        super(argv);
        super.addModule(this.modQuery);
        super.addModule(this.modOutput);
        super.addModule(this.modEngine);
        super.getUsage().startCategory(null);
        super.add(this.argDeclPrint, "--print", "Print in various forms [query, op, quad, optquad, plan]");
        super.add(this.argDeclExplain, "--explain", "Print with algebra-level optimization");
        super.add(this.argDeclOpt, "--opt", "[deprecated]");
        super.add(this.argDeclFixup, "--fixup", "Convert undeclared prefix names to URIs");
        E_Function.WarnOnUnknownFunction = false;
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(this.argDeclOpt)) {
            this.printOpt = true;
        }
        if (this.contains(this.argDeclExplain)) {
            this.printQuery = true;
            this.printOpt = true;
        }
        if (this.contains(this.argDeclFixup)) {
            ARQ.set(ARQ.fixupUndefinedPrefixes, true);
        }
        block22: for (String arg : this.getValues(this.argDeclPrint)) {
            switch (Lib.lowercase(arg)) {
                case "query": {
                    this.printQuery = true;
                    continue block22;
                }
                case "op": 
                case "alg": 
                case "algebra": {
                    this.printOp = true;
                    continue block22;
                }
                case "quad": 
                case "quads": {
                    this.printQuad = true;
                    continue block22;
                }
                case "plan": {
                    this.printPlan = true;
                    continue block22;
                }
                case "opt": {
                    this.printOpt = true;
                    continue block22;
                }
                case "optquad": 
                case "quadopt": {
                    this.printQuadOpt = true;
                    continue block22;
                }
                case "none": {
                    this.printNone = true;
                    continue block22;
                }
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, op, quad, opt, optquad, plan");
        }
        if (!(this.printQuery || this.printOp || this.printQuad || this.printPlan || this.printOpt || this.printQuadOpt || this.printNone)) {
            this.printQuery = true;
        }
    }

    @Override
    protected String getSummary() {
        return usage;
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    @Override
    protected void exec() {
        try {
            Query query2 = this.modQuery.getQuery();
            try {
                LogCtl.disable("SPARQL");
                QueryUtils.checkQuery(query2, true);
            }
            catch (QueryCheckException ex) {
                System.err.println();
                System.err.println("**** Check failure: " + ex.getMessage());
                if (ex.getCause() != null) {
                    ex.getCause().printStackTrace(System.err);
                }
            }
            finally {
                LogCtl.setLevel("SPARQL", "INFO");
            }
            if (this.printQuery) {
                this.divider();
                this.modOutput.output(query2);
            }
            if (this.printOp) {
                this.divider();
                this.modOutput.outputOp(query2, false);
            }
            if (this.printQuad) {
                this.divider();
                this.modOutput.outputQuad(query2, false);
            }
            if (this.printOpt) {
                this.divider();
                this.modOutput.outputOp(query2, true);
            }
            if (this.printQuadOpt) {
                this.divider();
                this.modOutput.outputQuad(query2, true);
            }
            if (this.printPlan) {
                this.divider();
                QueryExecution qExec = QueryExecutionFactory.create(query2, DatasetFactory.createGeneral());
                QueryOutputUtils.printPlan(query2, qExec);
            }
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (ResultSetException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (QueryException qEx) {
            throw new CmdException("Query Exeception", qEx);
        }
        catch (JenaException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", ex);
        }
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    static void writeSyntaxes(String msg, PrintStream out) {
        if (msg != null) {
            out.println(msg);
        }
        Iterator<String> iter = Syntax.querySyntaxNames.keys();
        while (iter.hasNext()) {
            String k = iter.next();
            Syntax v = Syntax.lookup(k);
            k = qparse.padOut(k, 10);
            out.println("  " + k + "  " + v);
        }
    }

    static String padOut(String x, int len) {
        StringBuilder r = new StringBuilder(x);
        for (int i = x.length(); i <= len; ++i) {
            r.append(" ");
        }
        return r.toString();
    }
}

