/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.engine.optimizer.StatsMatcher;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformationSubstitution;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.writers.WriterNode;

public class tdbreorder {
    public static void main(String ... args) {
        BasicPattern bgp;
        if (args.length != 2) {
            System.err.println("Usage: PATTERN STATS");
            System.exit(1);
        }
        LogCtl.enable(StatsMatcher.class);
        LogCtl.enable(ReorderTransformationSubstitution.class);
        if (args.length != 2) {
            System.err.println("Usage: op stats");
            System.exit(1);
        }
        String pattern = args[0];
        String statsFile = args[1];
        Op op = SSE.readOp(pattern);
        if (op instanceof OpQuadPattern) {
            OpQuadPattern opq = (OpQuadPattern)op;
            bgp = opq.getBasicPattern();
        } else if (op instanceof OpBGP) {
            OpBGP opbgp = (OpBGP)op;
            bgp = opbgp.getPattern();
        } else {
            System.err.println("Not a quad or triple pattern");
            System.exit(2);
            bgp = null;
        }
        ReorderTransformation reorder = tdbreorder.chooseReorder(statsFile);
        BasicPattern bgp2 = reorder.reorder(bgp);
        System.out.println();
        tdbreorder.print(bgp);
        System.out.println();
        System.out.println(" ======== >>>>>>>>");
        tdbreorder.print(bgp2);
        System.out.println();
    }

    private static void print(BasicPattern bgp) {
        IndentedWriter out = IndentedWriter.stdout;
        PrefixMapping pmap = SSE.getPrefixMapWrite();
        SerializationContext sCxt = SSE.sCxt(pmap);
        boolean first = true;
        for (Triple t2 : bgp) {
            if (!first) {
                out.print("\n");
            } else {
                first = false;
            }
            out.print("(");
            WriterNode.outputPlain(out, t2, sCxt);
            out.print(")");
        }
        out.flush();
    }

    private static ReorderTransformation chooseReorder(String filename) {
        if (filename.equals("fixed.opt")) {
            return ReorderLib.fixed();
        }
        if (filename.equals("none.opt")) {
            return ReorderLib.identity();
        }
        if (FileOps.exists(filename)) {
            return ReorderLib.weighted(filename);
        }
        throw new RuntimeException("No such file: " + filename);
    }
}

