/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ContentSourceCompletableFuture;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class FormFields
extends ContentSourceCompletableFuture<Fields> {
    public static final String MAX_FIELDS_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_LENGTH_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormContentSize";
    private static final CompletableFuture<Fields> EMPTY = CompletableFuture.completedFuture(Fields.EMPTY);
    private final Fields _fields;
    private final CharsetStringBuilder _builder;
    private final int _maxFields;
    private final int _maxLength;
    private int _length;
    private String _name;
    private int _percent = 0;
    private byte _percentCode;

    public static Charset getFormEncodedCharset(Request request) {
        String cs;
        HttpConfiguration config = request.getConnectionMetaData().getHttpConfiguration();
        if (!config.getFormEncodedMethods().contains(request.getMethod())) {
            return null;
        }
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (request.getLength() == 0L || StringUtil.isBlank(contentType)) {
            return null;
        }
        String contentTypeWithoutCharset = MimeTypes.getContentTypeWithoutCharset(contentType);
        MimeTypes.Type type = MimeTypes.CACHE.get(contentTypeWithoutCharset);
        if (type != null) {
            if (type != MimeTypes.Type.FORM_ENCODED) {
                return null;
            }
        } else {
            int semi = contentTypeWithoutCharset.indexOf(59);
            if (semi > 0) {
                contentTypeWithoutCharset = contentTypeWithoutCharset.substring(0, semi);
            }
            if (!MimeTypes.Type.FORM_ENCODED.is(contentTypeWithoutCharset.trim())) {
                return null;
            }
        }
        return StringUtil.isEmpty(cs = MimeTypes.getCharsetFromContentType(contentType)) ? StandardCharsets.UTF_8 : Charset.forName(cs);
    }

    public static void set(Request request, CompletableFuture<Fields> fields) {
        request.setAttribute(FormFields.class.getName(), fields);
    }

    public static CompletableFuture<Fields> get(Request request) {
        Object attr = request.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)attr;
            return futureFormFields;
        }
        return EMPTY;
    }

    public static CompletableFuture<Fields> from(Request request) {
        int maxFields = FormFields.getRequestAttribute(request, MAX_FIELDS_ATTRIBUTE);
        int maxLength = FormFields.getRequestAttribute(request, MAX_LENGTH_ATTRIBUTE);
        return FormFields.from(request, maxFields, maxLength);
    }

    public static CompletableFuture<Fields> from(Request request, Charset charset) {
        int maxFields = FormFields.getRequestAttribute(request, MAX_FIELDS_ATTRIBUTE);
        int maxLength = FormFields.getRequestAttribute(request, MAX_LENGTH_ATTRIBUTE);
        return FormFields.from(request, charset, maxFields, maxLength);
    }

    public static CompletableFuture<Fields> from(Request request, int maxFields, int maxLength) {
        return FormFields.from(request, FormFields.getFormEncodedCharset(request), maxFields, maxLength);
    }

    public static CompletableFuture<Fields> from(Request request, Charset charset, int maxFields, int maxLength) {
        return FormFields.from(request, request, charset, maxFields, maxLength);
    }

    static CompletableFuture<Fields> from(Content.Source source, Attributes attributes, Charset charset, int maxFields, int maxLength) {
        Object attr = attributes.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)attr;
            return futureFormFields;
        }
        if (attr instanceof Fields) {
            Fields fields = (Fields)attr;
            return CompletableFuture.completedFuture(fields);
        }
        if (charset == null) {
            return EMPTY;
        }
        FormFields futureFormFields = new FormFields(source, charset, maxFields, maxLength);
        attributes.setAttribute(FormFields.class.getName(), futureFormFields);
        futureFormFields.parse();
        return futureFormFields;
    }

    private static int getRequestAttribute(Request request, String attribute) {
        Object value = request.getAttribute(attribute);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException x) {
            return -1;
        }
    }

    private FormFields(Content.Source source, Charset charset, int maxFields, int maxSize) {
        super(source);
        this._maxFields = maxFields;
        this._maxLength = maxSize;
        this._builder = CharsetStringBuilder.forCharset(charset);
        this._fields = new Fields();
    }

    @Override
    protected Fields parse(Content.Chunk chunk) throws CharacterCodingException {
        ByteBuffer buffer = chunk.getByteBuffer();
        block15: while (BufferUtil.hasContent(buffer)) {
            byte b = buffer.get();
            switch (this._percent) {
                case 1: {
                    this._percentCode = b;
                    ++this._percent;
                    continue block15;
                }
                case 2: {
                    this._percent = 0;
                    this._builder.append(UrlEncoded.decodeHexByte((char)this._percentCode, (char)b));
                    continue block15;
                }
            }
            if (this._name == null) {
                switch (b) {
                    case 38: {
                        String name = this._builder.build();
                        this.checkMaxLength(name);
                        this.onNewField(name, "");
                        continue block15;
                    }
                    case 61: {
                        this._name = this._builder.build();
                        this.checkMaxLength(this._name);
                        continue block15;
                    }
                    case 43: {
                        this._builder.append(' ');
                        continue block15;
                    }
                    case 37: {
                        ++this._percent;
                        continue block15;
                    }
                }
                this._builder.append(b);
                continue;
            }
            switch (b) {
                case 38: {
                    String value = this._builder.build();
                    this.checkMaxLength(value);
                    this.onNewField(this._name, value);
                    this._name = null;
                    continue block15;
                }
                case 43: {
                    this._builder.append(' ');
                    continue block15;
                }
                case 37: {
                    ++this._percent;
                    continue block15;
                }
            }
            this._builder.append(b);
        }
        if (!chunk.isLast()) {
            return null;
        }
        if (this._percent > 0) {
            throw new IllegalStateException("invalid percent encoding");
        }
        String value = this._builder.build();
        if (this._name == null) {
            if (!value.isEmpty()) {
                this.checkMaxLength(value);
                this.onNewField(value, "");
            }
            return this._fields;
        }
        this.checkMaxLength(value);
        this.onNewField(this._name, value);
        return this._fields;
    }

    private void checkMaxLength(String nameOrValue) {
        if (this._maxLength >= 0) {
            this._length += nameOrValue.length();
            if (this._length > this._maxLength) {
                throw new IllegalStateException("form too large > " + this._maxLength);
            }
        }
    }

    private void onNewField(String name, String value) {
        Fields.Field field = new Fields.Field(name, value);
        this._fields.add(field);
        if (this._maxFields >= 0 && this._fields.getSize() > this._maxFields) {
            throw new IllegalStateException("form with too many fields > " + this._maxFields);
        }
    }
}

