/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.ImpactsSource;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.DisjunctionMatchesIterator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.ImpactsDISI;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.MaxScoreCache;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public final class SynonymQuery
extends Query {
    private final TermAndBoost[] terms;
    private final String field;

    private SynonymQuery(TermAndBoost[] terms, String field) {
        this.terms = Objects.requireNonNull(terms);
        this.field = Objects.requireNonNull(field);
    }

    public List<Term> getTerms() {
        return Collections.unmodifiableList(Arrays.stream(this.terms).map(t2 -> new Term(this.field, t2.term)).collect(Collectors.toList()));
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder("Synonym(");
        for (int i = 0; i < this.terms.length; ++i) {
            if (i != 0) {
                builder.append(" ");
            }
            TermQuery termQuery = new TermQuery(new Term(this.field, this.terms[i].term));
            builder.append(((Query)termQuery).toString(field));
            if (this.terms[i].boost == 1.0f) continue;
            builder.append("^");
            builder.append(this.terms[i].boost);
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + Arrays.hashCode(this.terms);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((SynonymQuery)other).field) && Arrays.equals(this.terms, ((SynonymQuery)other).terms);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.terms.length == 0) {
            return new BooleanQuery.Builder().build();
        }
        if (this.terms.length == 1 && this.terms[0].boost == 1.0f) {
            return new TermQuery(new Term(this.field, this.terms[0].term));
        }
        return this;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
        Term[] ts = (Term[])Arrays.stream(this.terms).map(t2 -> new Term(this.field, t2.term)).toArray(Term[]::new);
        v.consumeTerms(this, ts);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (scoreMode.needsScores()) {
            return new SynonymWeight(this, searcher, scoreMode, boost);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        for (TermAndBoost term : this.terms) {
            bq.add(new TermQuery(new Term(this.field, term.term)), BooleanClause.Occur.SHOULD);
        }
        return searcher.rewrite(bq.build()).createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
    }

    static ImpactsSource mergeImpacts(final ImpactsEnum[] impactsEnums, final float[] boosts) {
        assert (impactsEnums.length == boosts.length);
        return new ImpactsSource(){

            @Override
            public Impacts getImpacts() throws IOException {
                final Impacts[] impacts = new Impacts[impactsEnums.length];
                Impacts tmpLead = null;
                for (int i = 0; i < impactsEnums.length; ++i) {
                    impacts[i] = impactsEnums[i].getImpacts();
                    if (tmpLead != null && impacts[i].getDocIdUpTo(0) >= tmpLead.getDocIdUpTo(0)) continue;
                    tmpLead = impacts[i];
                }
                final Impacts lead = tmpLead;
                return new Impacts(){

                    @Override
                    public int numLevels() {
                        return lead.numLevels();
                    }

                    @Override
                    public int getDocIdUpTo(int level) {
                        return lead.getDocIdUpTo(level);
                    }

                    private int getLevel(Impacts impacts2, int docIdUpTo) {
                        int numLevels = impacts2.numLevels();
                        for (int level = 0; level < numLevels; ++level) {
                            if (impacts2.getDocIdUpTo(level) < docIdUpTo) continue;
                            return level;
                        }
                        return -1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public List<Impact> getImpacts(int level) {
                        int docIdUpTo = this.getDocIdUpTo(level);
                        ArrayList<void> toMerge = new ArrayList<void>();
                        for (int i = 0; i < impactsEnums.length; ++i) {
                            void var6_8;
                            if (impactsEnums[i].docID() > docIdUpTo) continue;
                            int impactsLevel = this.getLevel(impacts[i], docIdUpTo);
                            if (impactsLevel == -1) {
                                return Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
                            }
                            if (boosts[i] != 1.0f) {
                                float boost = boosts[i];
                                List list = impacts[i].getImpacts(impactsLevel).stream().map(impact -> new Impact((int)Math.ceil((float)impact.freq * boost), impact.norm)).collect(Collectors.toList());
                            } else {
                                List<Impact> list = impacts[i].getImpacts(impactsLevel);
                            }
                            toMerge.add(var6_8);
                        }
                        assert (toMerge.size() > 0);
                        if (toMerge.size() == 1) {
                            return (List)toMerge.get(0);
                        }
                        PriorityQueue<SubIterator> pq = new PriorityQueue<SubIterator>(impacts.length){

                            @Override
                            protected boolean lessThan(SubIterator a, SubIterator b) {
                                if (a.current == null) {
                                    return false;
                                }
                                if (b.current == null) {
                                    return true;
                                }
                                return Long.compareUnsigned(a.current.norm, b.current.norm) < 0;
                            }
                        };
                        for (List list : toMerge) {
                            pq.add(new SubIterator(list.iterator()));
                        }
                        ArrayList<Impact> mergedImpacts = new ArrayList<Impact>();
                        long l = 0L;
                        SubIterator top = (SubIterator)pq.top();
                        do {
                            long norm = top.current.norm;
                            do {
                                l += (long)(top.current.freq - top.previousFreq);
                                top.next();
                                top = (SubIterator)pq.updateTop();
                            } while (top.current != null && top.current.norm == norm);
                            int freqUpperBound = (int)Math.min(Integer.MAX_VALUE, l);
                            if (mergedImpacts.isEmpty()) {
                                mergedImpacts.add(new Impact(freqUpperBound, norm));
                                continue;
                            }
                            Impact prevImpact = (Impact)mergedImpacts.get(mergedImpacts.size() - 1);
                            assert (Long.compareUnsigned(prevImpact.norm, norm) < 0);
                            if (freqUpperBound <= prevImpact.freq) continue;
                            mergedImpacts.add(new Impact(freqUpperBound, norm));
                        } while (top.current != null);
                        return mergedImpacts;
                    }
                };
            }

            @Override
            public void advanceShallow(int target) throws IOException {
                for (ImpactsEnum impactsEnum : impactsEnums) {
                    if (impactsEnum.docID() >= target) continue;
                    impactsEnum.advanceShallow(target);
                }
            }

            class SubIterator {
                final Iterator<Impact> iterator;
                int previousFreq;
                Impact current;

                SubIterator(Iterator<Impact> iterator) {
                    this.iterator = iterator;
                    this.current = iterator.next();
                }

                void next() {
                    this.previousFreq = this.current.freq;
                    this.current = !this.iterator.hasNext() ? null : this.iterator.next();
                }
            }
        };
    }

    private static class TermAndBoost {
        final BytesRef term;
        final float boost;

        TermAndBoost(BytesRef term, float boost) {
            this.term = term;
            this.boost = boost;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TermAndBoost that = (TermAndBoost)o;
            return Float.compare(that.boost, this.boost) == 0 && Objects.equals(this.term, that.term);
        }

        public int hashCode() {
            return Objects.hash(this.term, Float.valueOf(this.boost));
        }
    }

    private static class FreqBoostTermScorer
    extends FilterScorer {
        final float boost;
        final TermScorer in;
        final LeafSimScorer docScorer;

        public FreqBoostTermScorer(float boost, TermScorer in, LeafSimScorer docScorer) {
            super(in);
            if (Float.isNaN(boost) || Float.compare(boost, 0.0f) < 0 || Float.compare(boost, 1.0f) > 0) {
                throw new IllegalArgumentException("boost must be a positive float between 0 (exclusive) and 1 (inclusive)");
            }
            this.boost = boost;
            this.in = in;
            this.docScorer = docScorer;
        }

        float freq() throws IOException {
            return this.boost * (float)this.in.freq();
        }

        @Override
        public float score() throws IOException {
            assert (this.docID() != Integer.MAX_VALUE);
            return this.docScorer.score(this.in.docID(), this.freq());
        }

        @Override
        public float getMaxScore(int upTo) throws IOException {
            return this.in.getMaxScore(upTo);
        }

        @Override
        public int advanceShallow(int target) throws IOException {
            return this.in.advanceShallow(target);
        }

        @Override
        public void setMinCompetitiveScore(float minScore) throws IOException {
            this.in.setMinCompetitiveScore(minScore);
        }
    }

    private static class DisiWrapperFreq
    extends DisiWrapper {
        final PostingsEnum pe;
        final float boost;

        DisiWrapperFreq(Scorer scorer, float boost) {
            super(scorer);
            this.pe = (PostingsEnum)scorer.iterator();
            this.boost = boost;
        }

        float freq() throws IOException {
            return this.boost * (float)this.pe.freq();
        }
    }

    private static class SynonymScorer
    extends Scorer {
        private final DisiPriorityQueue queue;
        private final DocIdSetIterator iterator;
        private final MaxScoreCache maxScoreCache;
        private final ImpactsDISI impactsDisi;
        private final LeafSimScorer simScorer;

        SynonymScorer(Weight weight, DisiPriorityQueue queue, DocIdSetIterator iterator, ImpactsDISI impactsDisi, LeafSimScorer simScorer) {
            super(weight);
            this.queue = queue;
            this.iterator = iterator;
            this.maxScoreCache = impactsDisi.getMaxScoreCache();
            this.impactsDisi = impactsDisi;
            this.simScorer = simScorer;
        }

        @Override
        public int docID() {
            return this.iterator.docID();
        }

        float freq() throws IOException {
            DisiWrapperFreq w = (DisiWrapperFreq)this.queue.topList();
            float freq = w.freq();
            w = (DisiWrapperFreq)w.next;
            while (w != null) {
                freq += w.freq();
                w = (DisiWrapperFreq)w.next;
            }
            return freq;
        }

        @Override
        public float score() throws IOException {
            return this.simScorer.score(this.iterator.docID(), this.freq());
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.iterator;
        }

        @Override
        public float getMaxScore(int upTo) throws IOException {
            return this.maxScoreCache.getMaxScore(upTo);
        }

        @Override
        public int advanceShallow(int target) throws IOException {
            return this.maxScoreCache.advanceShallow(target);
        }

        @Override
        public void setMinCompetitiveScore(float minScore) {
            this.impactsDisi.setMinCompetitiveScore(minScore);
        }
    }

    class SynonymWeight
    extends Weight {
        private final TermStates[] termStates;
        private final Similarity similarity;
        private final Similarity.SimScorer simWeight;
        private final ScoreMode scoreMode;

        SynonymWeight(Query query2, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            super(query2);
            assert (scoreMode.needsScores());
            this.scoreMode = scoreMode;
            CollectionStatistics collectionStats = searcher.collectionStatistics(SynonymQuery.this.field);
            long docFreq = 0L;
            long totalTermFreq = 0L;
            this.termStates = new TermStates[SynonymQuery.this.terms.length];
            for (int i = 0; i < this.termStates.length; ++i) {
                TermStates ts;
                Term term = new Term(SynonymQuery.this.field, SynonymQuery.this.terms[i].term);
                this.termStates[i] = ts = TermStates.build(searcher, term, true);
                if (ts.docFreq() <= 0) continue;
                TermStatistics termStats = searcher.termStatistics(term, ts.docFreq(), ts.totalTermFreq());
                docFreq = Math.max(termStats.docFreq(), docFreq);
                totalTermFreq += termStats.totalTermFreq();
            }
            this.similarity = searcher.getSimilarity();
            if (docFreq > 0L) {
                TermStatistics pseudoStats = new TermStatistics(new BytesRef("synonym pseudo-term"), docFreq, totalTermFreq);
                this.simWeight = this.similarity.scorer(boost, collectionStats, pseudoStats);
            } else {
                this.simWeight = null;
            }
        }

        @Override
        public Matches matches(LeafReaderContext context2, int doc) throws IOException {
            Terms indexTerms = context2.reader().terms(SynonymQuery.this.field);
            if (indexTerms == null) {
                return super.matches(context2, doc);
            }
            List termList = Arrays.stream(SynonymQuery.this.terms).map(t2 -> new Term(SynonymQuery.this.field, t2.term)).collect(Collectors.toList());
            return MatchesUtils.forField(SynonymQuery.this.field, () -> DisjunctionMatchesIterator.fromTerms(context2, doc, this.getQuery(), SynonymQuery.this.field, termList));
        }

        @Override
        public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
            int newDoc;
            Scorer scorer = this.scorer(context2);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq;
                if (scorer instanceof SynonymScorer) {
                    freq = ((SynonymScorer)scorer).freq();
                } else if (scorer instanceof FreqBoostTermScorer) {
                    freq = ((FreqBoostTermScorer)scorer).freq();
                } else {
                    assert (scorer instanceof TermScorer);
                    freq = ((TermScorer)scorer).freq();
                }
                LeafSimScorer docScorer = new LeafSimScorer(this.simWeight, context2.reader(), SynonymQuery.this.field, true);
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), "termFreq=" + freq, new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }

        @Override
        public Scorer scorer(LeafReaderContext context2) throws IOException {
            ArrayList<PostingsEnum> iterators = new ArrayList<PostingsEnum>();
            ArrayList<ImpactsEnum> impacts = new ArrayList<ImpactsEnum>();
            ArrayList<Float> termBoosts = new ArrayList<Float>();
            for (int i = 0; i < SynonymQuery.this.terms.length; ++i) {
                TermState state = this.termStates[i].get(context2);
                if (state == null) continue;
                TermsEnum termsEnum = context2.reader().terms(SynonymQuery.this.field).iterator();
                termsEnum.seekExact(SynonymQuery.this.terms[i].term, state);
                if (this.scoreMode == ScoreMode.TOP_SCORES) {
                    ImpactsEnum impactsEnum = termsEnum.impacts(8);
                    iterators.add(impactsEnum);
                    impacts.add(impactsEnum);
                } else {
                    PostingsEnum postingsEnum = termsEnum.postings(null, 8);
                    iterators.add(postingsEnum);
                    impacts.add(new SlowImpactsEnum(postingsEnum));
                }
                termBoosts.add(Float.valueOf(SynonymQuery.this.terms[i].boost));
            }
            if (iterators.isEmpty()) {
                return null;
            }
            LeafSimScorer simScorer = new LeafSimScorer(this.simWeight, context2.reader(), SynonymQuery.this.field, true);
            if (iterators.size() == 1) {
                TermScorer scorer = this.scoreMode == ScoreMode.TOP_SCORES ? new TermScorer(this, (PostingsEnum)impacts.get(0), simScorer) : new TermScorer(this, (PostingsEnum)iterators.get(0), simScorer);
                float boost = ((Float)termBoosts.get(0)).floatValue();
                return this.scoreMode == ScoreMode.COMPLETE_NO_SCORES || boost == 1.0f ? scorer : new FreqBoostTermScorer(boost, scorer, simScorer);
            }
            DisiPriorityQueue queue = new DisiPriorityQueue(iterators.size());
            for (int i = 0; i < iterators.size(); ++i) {
                PostingsEnum postings = (PostingsEnum)iterators.get(i);
                TermScorer termScorer = new TermScorer(this, postings, simScorer);
                float boost = ((Float)termBoosts.get(i)).floatValue();
                DisiWrapperFreq wrapper = new DisiWrapperFreq(termScorer, boost);
                queue.add(wrapper);
            }
            DocIdSetIterator iterator = new DisjunctionDISIApproximation(queue);
            float[] boosts = new float[impacts.size()];
            for (int i = 0; i < boosts.length; ++i) {
                boosts[i] = ((Float)termBoosts.get(i)).floatValue();
            }
            ImpactsSource impactsSource = SynonymQuery.mergeImpacts(impacts.toArray(new ImpactsEnum[0]), boosts);
            MaxScoreCache maxScoreCache = new MaxScoreCache(impactsSource, simScorer.getSimScorer());
            ImpactsDISI impactsDisi = new ImpactsDISI(iterator, maxScoreCache);
            if (this.scoreMode == ScoreMode.TOP_SCORES) {
                iterator = impactsDisi;
            }
            return new SynonymScorer(this, queue, iterator, impactsDisi, simScorer);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }

    public static class Builder {
        private final String field;
        private final List<TermAndBoost> terms = new ArrayList<TermAndBoost>();

        public Builder(String field) {
            this.field = field;
        }

        public Builder addTerm(Term term) {
            return this.addTerm(term, 1.0f);
        }

        public Builder addTerm(Term term, float boost) {
            if (!this.field.equals(term.field())) {
                throw new IllegalArgumentException("Synonyms must be across the same field");
            }
            return this.addTerm(term.bytes(), boost);
        }

        public Builder addTerm(BytesRef term, float boost) {
            if (Float.isNaN(boost) || Float.compare(boost, 0.0f) <= 0 || Float.compare(boost, 1.0f) > 0) {
                throw new IllegalArgumentException("boost must be a positive float between 0 (exclusive) and 1 (inclusive)");
            }
            this.terms.add(new TermAndBoost(term, boost));
            if (this.terms.size() > IndexSearcher.getMaxClauseCount()) {
                throw new IndexSearcher.TooManyClauses();
            }
            return this;
        }

        public SynonymQuery build() {
            Collections.sort(this.terms, Comparator.comparing(a -> a.term));
            return new SynonymQuery(this.terms.toArray(new TermAndBoost[0]), this.field);
        }
    }
}

