/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompetitiveImpactAccumulator;
import org.apache.lucene.codecs.PushPostingsWriterBase;
import org.apache.lucene.codecs.lucene99.ForDeltaUtil;
import org.apache.lucene.codecs.lucene99.ForUtil;
import org.apache.lucene.codecs.lucene99.GroupVIntWriter;
import org.apache.lucene.codecs.lucene99.Lucene99PostingsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99SkipWriter;
import org.apache.lucene.codecs.lucene99.PForUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public final class Lucene99PostingsWriter
extends PushPostingsWriterBase {
    IndexOutput docOut;
    IndexOutput posOut;
    IndexOutput payOut;
    static final Lucene99PostingsFormat.IntBlockTermState emptyState = new Lucene99PostingsFormat.IntBlockTermState();
    Lucene99PostingsFormat.IntBlockTermState lastState;
    private long docStartFP;
    private long posStartFP;
    private long payStartFP;
    final long[] docDeltaBuffer;
    final long[] freqBuffer;
    private int docBufferUpto;
    final long[] posDeltaBuffer;
    final long[] payloadLengthBuffer;
    final long[] offsetStartDeltaBuffer;
    final long[] offsetLengthBuffer;
    private int posBufferUpto;
    private byte[] payloadBytes;
    private int payloadByteUpto;
    private int lastBlockDocID;
    private long lastBlockPosFP;
    private long lastBlockPayFP;
    private int lastBlockPosBufferUpto;
    private int lastBlockPayloadByteUpto;
    private int lastDocID;
    private int lastPosition;
    private int lastStartOffset;
    private int docCount;
    private final PForUtil pforUtil;
    private final ForDeltaUtil forDeltaUtil;
    private final Lucene99SkipWriter skipWriter;
    private final GroupVIntWriter docGroupVIntWriter;
    private boolean fieldHasNorms;
    private NumericDocValues norms;
    private final CompetitiveImpactAccumulator competitiveFreqNormAccumulator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lucene99PostingsWriter(SegmentWriteState state) throws IOException {
        IndexOutput payOut;
        IndexOutput posOut;
        block10: {
            this.competitiveFreqNormAccumulator = new CompetitiveImpactAccumulator();
            String docFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "doc");
            this.docOut = state.directory.createOutput(docFileName, state.context);
            posOut = null;
            payOut = null;
            boolean success = false;
            try {
                CodecUtil.writeIndexHeader(this.docOut, "Lucene99PostingsWriterDoc", 0, state.segmentInfo.getId(), state.segmentSuffix);
                ForUtil forUtil = new ForUtil();
                this.forDeltaUtil = new ForDeltaUtil(forUtil);
                this.pforUtil = new PForUtil(forUtil);
                if (state.fieldInfos.hasProx()) {
                    this.posDeltaBuffer = new long[128];
                    String posFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pos");
                    posOut = state.directory.createOutput(posFileName, state.context);
                    CodecUtil.writeIndexHeader(posOut, "Lucene99PostingsWriterPos", 0, state.segmentInfo.getId(), state.segmentSuffix);
                    if (state.fieldInfos.hasPayloads()) {
                        this.payloadBytes = new byte[128];
                        this.payloadLengthBuffer = new long[128];
                    } else {
                        this.payloadBytes = null;
                        this.payloadLengthBuffer = null;
                    }
                    if (state.fieldInfos.hasOffsets()) {
                        this.offsetStartDeltaBuffer = new long[128];
                        this.offsetLengthBuffer = new long[128];
                    } else {
                        this.offsetStartDeltaBuffer = null;
                        this.offsetLengthBuffer = null;
                    }
                    if (state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets()) {
                        String payFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pay");
                        payOut = state.directory.createOutput(payFileName, state.context);
                        CodecUtil.writeIndexHeader(payOut, "Lucene99PostingsWriterPay", 0, state.segmentInfo.getId(), state.segmentSuffix);
                    }
                } else {
                    this.posDeltaBuffer = null;
                    this.payloadLengthBuffer = null;
                    this.offsetStartDeltaBuffer = null;
                    this.offsetLengthBuffer = null;
                    this.payloadBytes = null;
                }
                this.payOut = payOut;
                this.posOut = posOut;
                success = true;
                if (success) break block10;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.docOut, posOut, payOut);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.docOut, posOut, payOut);
        }
        this.docDeltaBuffer = new long[128];
        this.freqBuffer = new long[128];
        this.skipWriter = new Lucene99SkipWriter(10, 128, state.segmentInfo.maxDoc(), this.docOut, posOut, payOut);
        this.docGroupVIntWriter = new GroupVIntWriter();
    }

    @Override
    public Lucene99PostingsFormat.IntBlockTermState newTermState() {
        return new Lucene99PostingsFormat.IntBlockTermState();
    }

    @Override
    public void init(IndexOutput termsOut, SegmentWriteState state) throws IOException {
        CodecUtil.writeIndexHeader(termsOut, "Lucene90PostingsWriterTerms", 0, state.segmentInfo.getId(), state.segmentSuffix);
        termsOut.writeVInt(128);
    }

    @Override
    public void setField(FieldInfo fieldInfo) {
        super.setField(fieldInfo);
        this.skipWriter.setField(this.writePositions, this.writeOffsets, this.writePayloads);
        this.lastState = emptyState;
        this.fieldHasNorms = fieldInfo.hasNorms();
    }

    @Override
    public void startTerm(NumericDocValues norms) {
        this.docStartFP = this.docOut.getFilePointer();
        if (this.writePositions) {
            this.posStartFP = this.posOut.getFilePointer();
            if (this.writePayloads || this.writeOffsets) {
                this.payStartFP = this.payOut.getFilePointer();
            }
        }
        this.lastDocID = 0;
        this.lastBlockDocID = -1;
        this.skipWriter.resetSkip();
        this.norms = norms;
        this.competitiveFreqNormAccumulator.clear();
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        long norm;
        if (this.lastBlockDocID != -1 && this.docBufferUpto == 0) {
            this.skipWriter.bufferSkip(this.lastBlockDocID, this.competitiveFreqNormAccumulator, this.docCount, this.lastBlockPosFP, this.lastBlockPayFP, this.lastBlockPosBufferUpto, this.lastBlockPayloadByteUpto);
            this.competitiveFreqNormAccumulator.clear();
        }
        int docDelta = docID - this.lastDocID;
        if (docID < 0 || this.docCount > 0 && docDelta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " )", this.docOut);
        }
        this.docDeltaBuffer[this.docBufferUpto] = docDelta;
        if (this.writeFreqs) {
            this.freqBuffer[this.docBufferUpto] = termDocFreq;
        }
        ++this.docBufferUpto;
        ++this.docCount;
        if (this.docBufferUpto == 128) {
            this.forDeltaUtil.encodeDeltas(this.docDeltaBuffer, this.docOut);
            if (this.writeFreqs) {
                this.pforUtil.encode(this.freqBuffer, this.docOut);
            }
        }
        this.lastDocID = docID;
        this.lastPosition = 0;
        this.lastStartOffset = 0;
        if (this.fieldHasNorms) {
            boolean found = this.norms.advanceExact(docID);
            if (!found) {
                norm = 1L;
            } else {
                norm = this.norms.longValue();
                assert (norm != 0L) : docID;
            }
        } else {
            norm = 1L;
        }
        this.competitiveFreqNormAccumulator.add(this.writeFreqs ? termDocFreq : 1, norm);
    }

    @Override
    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        if (position > 0x7FFFFF7F) {
            throw new CorruptIndexException("position=" + position + " is too large (> IndexWriter.MAX_POSITION=2147483519)", this.docOut);
        }
        if (position < 0) {
            throw new CorruptIndexException("position=" + position + " is < 0", this.docOut);
        }
        this.posDeltaBuffer[this.posBufferUpto] = position - this.lastPosition;
        if (this.writePayloads) {
            if (payload == null || payload.length == 0) {
                this.payloadLengthBuffer[this.posBufferUpto] = 0L;
            } else {
                this.payloadLengthBuffer[this.posBufferUpto] = payload.length;
                if (this.payloadByteUpto + payload.length > this.payloadBytes.length) {
                    this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + payload.length);
                }
                System.arraycopy(payload.bytes, payload.offset, this.payloadBytes, this.payloadByteUpto, payload.length);
                this.payloadByteUpto += payload.length;
            }
        }
        if (this.writeOffsets) {
            assert (startOffset >= this.lastStartOffset);
            assert (endOffset >= startOffset);
            this.offsetStartDeltaBuffer[this.posBufferUpto] = startOffset - this.lastStartOffset;
            this.offsetLengthBuffer[this.posBufferUpto] = endOffset - startOffset;
            this.lastStartOffset = startOffset;
        }
        ++this.posBufferUpto;
        this.lastPosition = position;
        if (this.posBufferUpto == 128) {
            this.pforUtil.encode(this.posDeltaBuffer, this.posOut);
            if (this.writePayloads) {
                this.pforUtil.encode(this.payloadLengthBuffer, this.payOut);
                this.payOut.writeVInt(this.payloadByteUpto);
                this.payOut.writeBytes(this.payloadBytes, 0, this.payloadByteUpto);
                this.payloadByteUpto = 0;
            }
            if (this.writeOffsets) {
                this.pforUtil.encode(this.offsetStartDeltaBuffer, this.payOut);
                this.pforUtil.encode(this.offsetLengthBuffer, this.payOut);
            }
            this.posBufferUpto = 0;
        }
    }

    @Override
    public void finishDoc() throws IOException {
        if (this.docBufferUpto == 128) {
            this.lastBlockDocID = this.lastDocID;
            if (this.posOut != null) {
                if (this.payOut != null) {
                    this.lastBlockPayFP = this.payOut.getFilePointer();
                }
                this.lastBlockPosFP = this.posOut.getFilePointer();
                this.lastBlockPosBufferUpto = this.posBufferUpto;
                this.lastBlockPayloadByteUpto = this.payloadByteUpto;
            }
            this.docBufferUpto = 0;
        }
    }

    @Override
    public void finishTerm(BlockTermState _state) throws IOException {
        long lastPosBlockOffset;
        int singletonDocID;
        Lucene99PostingsFormat.IntBlockTermState state = (Lucene99PostingsFormat.IntBlockTermState)_state;
        assert (state.docFreq > 0);
        assert (state.docFreq == this.docCount) : state.docFreq + " vs " + this.docCount;
        if (state.docFreq == 1) {
            singletonDocID = (int)this.docDeltaBuffer[0];
        } else {
            int i;
            singletonDocID = -1;
            if (this.writeFreqs) {
                for (i = 0; i < this.docBufferUpto; ++i) {
                    this.docDeltaBuffer[i] = this.docDeltaBuffer[i] << 1 | (long)(this.freqBuffer[i] == 1L ? 1 : 0);
                }
            }
            this.docGroupVIntWriter.writeValues(this.docOut, this.docDeltaBuffer, this.docBufferUpto);
            if (this.writeFreqs) {
                for (i = 0; i < this.docBufferUpto; ++i) {
                    int freq = (int)this.freqBuffer[i];
                    if (freq == 1) continue;
                    this.docOut.writeVInt(freq);
                }
            }
        }
        if (this.writePositions) {
            assert (state.totalTermFreq != -1L);
            lastPosBlockOffset = state.totalTermFreq > 128L ? this.posOut.getFilePointer() - this.posStartFP : -1L;
            if (this.posBufferUpto > 0) {
                int lastPayloadLength = -1;
                int lastOffsetLength = -1;
                int payloadBytesReadUpto = 0;
                for (int i = 0; i < this.posBufferUpto; ++i) {
                    int posDelta = (int)this.posDeltaBuffer[i];
                    if (this.writePayloads) {
                        int payloadLength = (int)this.payloadLengthBuffer[i];
                        if (payloadLength != lastPayloadLength) {
                            lastPayloadLength = payloadLength;
                            this.posOut.writeVInt(posDelta << 1 | 1);
                            this.posOut.writeVInt(payloadLength);
                        } else {
                            this.posOut.writeVInt(posDelta << 1);
                        }
                        if (payloadLength != 0) {
                            this.posOut.writeBytes(this.payloadBytes, payloadBytesReadUpto, payloadLength);
                            payloadBytesReadUpto += payloadLength;
                        }
                    } else {
                        this.posOut.writeVInt(posDelta);
                    }
                    if (!this.writeOffsets) continue;
                    int delta = (int)this.offsetStartDeltaBuffer[i];
                    int length = (int)this.offsetLengthBuffer[i];
                    if (length == lastOffsetLength) {
                        this.posOut.writeVInt(delta << 1);
                        continue;
                    }
                    this.posOut.writeVInt(delta << 1 | 1);
                    this.posOut.writeVInt(length);
                    lastOffsetLength = length;
                }
                if (this.writePayloads) {
                    assert (payloadBytesReadUpto == this.payloadByteUpto);
                    this.payloadByteUpto = 0;
                }
            }
        } else {
            lastPosBlockOffset = -1L;
        }
        long skipOffset = this.docCount > 128 ? this.skipWriter.writeSkip(this.docOut) - this.docStartFP : -1L;
        state.docStartFP = this.docStartFP;
        state.posStartFP = this.posStartFP;
        state.payStartFP = this.payStartFP;
        state.singletonDocID = singletonDocID;
        state.skipOffset = skipOffset;
        state.lastPosBlockOffset = lastPosBlockOffset;
        this.docBufferUpto = 0;
        this.posBufferUpto = 0;
        this.lastDocID = 0;
        this.docCount = 0;
    }

    @Override
    public void encodeTerm(DataOutput out, FieldInfo fieldInfo, BlockTermState _state, boolean absolute) throws IOException {
        Lucene99PostingsFormat.IntBlockTermState state = (Lucene99PostingsFormat.IntBlockTermState)_state;
        if (absolute) {
            this.lastState = emptyState;
            assert (this.lastState.docStartFP == 0L);
        }
        if (this.lastState.singletonDocID != -1 && state.singletonDocID != -1 && state.docStartFP == this.lastState.docStartFP) {
            long delta = (long)state.singletonDocID - (long)this.lastState.singletonDocID;
            out.writeVLong(BitUtil.zigZagEncode(delta) << 1 | 1L);
        } else {
            out.writeVLong(state.docStartFP - this.lastState.docStartFP << 1);
            if (state.singletonDocID != -1) {
                out.writeVInt(state.singletonDocID);
            }
        }
        if (this.writePositions) {
            out.writeVLong(state.posStartFP - this.lastState.posStartFP);
            if (this.writePayloads || this.writeOffsets) {
                out.writeVLong(state.payStartFP - this.lastState.payStartFP);
            }
        }
        if (this.writePositions && state.lastPosBlockOffset != -1L) {
            out.writeVLong(state.lastPosBlockOffset);
        }
        if (state.skipOffset != -1L) {
            out.writeVLong(state.skipOffset);
        }
        this.lastState = state;
    }

    @Override
    public void close() throws IOException {
        block8: {
            block7: {
                boolean success = false;
                try {
                    if (this.docOut != null) {
                        CodecUtil.writeFooter(this.docOut);
                    }
                    if (this.posOut != null) {
                        CodecUtil.writeFooter(this.posOut);
                    }
                    if (this.payOut != null) {
                        CodecUtil.writeFooter(this.payOut);
                    }
                    if (!(success = true)) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.docOut, this.posOut, this.payOut);
                    } else {
                        IOUtils.closeWhileHandlingException(this.docOut, this.posOut, this.payOut);
                    }
                    this.payOut = null;
                    this.posOut = null;
                    this.docOut = null;
                    throw throwable;
                }
                IOUtils.close(this.docOut, this.posOut, this.payOut);
                break block8;
            }
            IOUtils.closeWhileHandlingException(this.docOut, this.posOut, this.payOut);
        }
        this.payOut = null;
        this.posOut = null;
        this.docOut = null;
    }
}

