/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene50.compressing;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.backward_codecs.compressing.CompressionMode;
import org.apache.lucene.backward_codecs.compressing.Decompressor;
import org.apache.lucene.backward_codecs.lucene50.compressing.FieldsIndex;
import org.apache.lucene.backward_codecs.lucene50.compressing.FieldsIndexReader;
import org.apache.lucene.backward_codecs.lucene50.compressing.LegacyFieldsIndexReader;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.PackedInts;

public final class Lucene50CompressingStoredFieldsReader
extends StoredFieldsReader {
    public static final String FIELDS_EXTENSION = "fdt";
    public static final String INDEX_EXTENSION = "fdx";
    public static final String META_EXTENSION = "fdm";
    public static final String INDEX_CODEC_NAME = "Lucene85FieldsIndex";
    static final int STRING = 0;
    static final int BYTE_ARR = 1;
    static final int NUMERIC_INT = 2;
    static final int NUMERIC_FLOAT = 3;
    static final int NUMERIC_LONG = 4;
    static final int NUMERIC_DOUBLE = 5;
    static final int TYPE_BITS = PackedInts.bitsRequired(5L);
    static final int TYPE_MASK = (int)PackedInts.maxValue(TYPE_BITS);
    static final int VERSION_START = 1;
    static final int VERSION_OFFHEAP_INDEX = 2;
    static final int VERSION_META = 3;
    static final int VERSION_NUM_CHUNKS = 4;
    static final int VERSION_CURRENT = 4;
    static final int META_VERSION_START = 0;
    static final long SECOND = 1000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final int SECOND_ENCODING = 64;
    static final int HOUR_ENCODING = 128;
    static final int DAY_ENCODING = 192;
    private final int version;
    private final FieldInfos fieldInfos;
    private final FieldsIndex indexReader;
    private final long maxPointer;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final int numDocs;
    private final boolean merging;
    private final BlockState state;
    private boolean closed;

    private Lucene50CompressingStoredFieldsReader(Lucene50CompressingStoredFieldsReader reader, boolean merging) {
        this.version = reader.version;
        this.fieldInfos = reader.fieldInfos;
        this.fieldsStream = reader.fieldsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.maxPointer = reader.maxPointer;
        this.chunkSize = reader.chunkSize;
        this.packedIntsVersion = reader.packedIntsVersion;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.numDocs = reader.numDocs;
        this.merging = merging;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene50CompressingStoredFieldsReader(Directory d, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context2, String formatName, CompressionMode compressionMode) throws IOException {
        this.compressionMode = compressionMode;
        String segment = si.name;
        boolean success = false;
        this.fieldInfos = fn;
        this.numDocs = si.maxDoc();
        String fieldsStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, FIELDS_EXTENSION);
        DataInput metaIn = null;
        try {
            void var14_19;
            this.fieldsStream = EndiannessReverserUtil.openInput(d, fieldsStreamFN, context2);
            this.version = CodecUtil.checkIndexHeader(this.fieldsStream, formatName, 1, 4, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength(formatName, segmentSuffix) == this.fieldsStream.getFilePointer());
            if (this.version >= 2) {
                String metaStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, META_EXTENSION);
                metaIn = EndiannessReverserUtil.openChecksumInput(d, metaStreamFN, IOContext.READONCE);
                CodecUtil.checkIndexHeader(metaIn, "Lucene85FieldsIndexMeta", 0, this.version, si.getId(), segmentSuffix);
            }
            if (this.version >= 3) {
                this.chunkSize = metaIn.readVInt();
                this.packedIntsVersion = metaIn.readVInt();
            } else {
                this.chunkSize = this.fieldsStream.readVInt();
                this.packedIntsVersion = this.fieldsStream.readVInt();
            }
            this.decompressor = compressionMode.newDecompressor();
            this.merging = false;
            this.state = new BlockState();
            CodecUtil.retrieveChecksum(this.fieldsStream);
            long maxPointer = -1L;
            Object var14_15 = null;
            if (this.version < 2) {
                String indexName = IndexFileNames.segmentFileName(segment, segmentSuffix, INDEX_EXTENSION);
                try (ChecksumIndexInput indexStream = EndiannessReverserUtil.openChecksumInput(d, indexName, context2);){
                    Throwable priorE = null;
                    try {
                        assert (formatName.endsWith("Data"));
                        String codecNameIdx = formatName.substring(0, formatName.length() - "Data".length()) + "Index";
                        int version2 = CodecUtil.checkIndexHeader(indexStream, codecNameIdx, 1, 4, si.getId(), segmentSuffix);
                        if (this.version != version2) {
                            throw new CorruptIndexException("Version mismatch between stored fields index and data: " + version2 + " != " + this.version, indexStream);
                        }
                        assert ((long)CodecUtil.indexHeaderLength(codecNameIdx, segmentSuffix) == indexStream.getFilePointer());
                        LegacyFieldsIndexReader legacyFieldsIndexReader = new LegacyFieldsIndexReader(indexStream, si);
                        maxPointer = indexStream.readVLong();
                    }
                    catch (Throwable exception) {
                        try {
                            priorE = exception;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter(indexStream, priorE);
                        }
                    }
                    CodecUtil.checkFooter(indexStream, priorE);
                }
            } else {
                FieldsIndexReader fieldsIndexReader;
                FieldsIndexReader fieldsIndexReader2 = fieldsIndexReader = new FieldsIndexReader(d, si.name, segmentSuffix, INDEX_EXTENSION, INDEX_CODEC_NAME, si.getId(), (IndexInput)metaIn);
                maxPointer = fieldsIndexReader.getMaxPointer();
            }
            this.maxPointer = maxPointer;
            this.indexReader = var14_19;
            if (this.version >= 4) {
                metaIn.readVLong();
            }
            if (this.version >= 3) {
                metaIn.readVLong();
                metaIn.readVLong();
            }
            if (metaIn != null) {
                CodecUtil.checkFooter((ChecksumIndexInput)metaIn, null);
                ((IndexInput)metaIn).close();
            }
            if (success = true) return;
        }
        catch (Throwable t2) {
            try {
                if (metaIn == null) throw t2;
                CodecUtil.checkFooter(metaIn, t2);
                throw new AssertionError((Object)"unreachable");
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(new Closeable[]{this, metaIn});
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(new Closeable[]{this, metaIn});
        return;
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.indexReader, this.fieldsStream);
            this.closed = true;
        }
    }

    private static void readField(DataInput in, StoredFieldVisitor visitor, FieldInfo info, int bits) throws IOException {
        switch (bits & TYPE_MASK) {
            case 1: {
                int length = in.readVInt();
                visitor.binaryField(info, in, length);
                break;
            }
            case 0: {
                visitor.stringField(info, in.readString());
                break;
            }
            case 2: {
                visitor.intField(info, in.readZInt());
                break;
            }
            case 3: {
                visitor.floatField(info, Lucene50CompressingStoredFieldsReader.readZFloat(in));
                break;
            }
            case 4: {
                visitor.longField(info, Lucene50CompressingStoredFieldsReader.readTLong(in));
                break;
            }
            case 5: {
                visitor.doubleField(info, Lucene50CompressingStoredFieldsReader.readZDouble(in));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    private static void skipField(DataInput in, int bits) throws IOException {
        switch (bits & TYPE_MASK) {
            case 0: 
            case 1: {
                int length = in.readVInt();
                in.skipBytes(length);
                break;
            }
            case 2: {
                in.readZInt();
                break;
            }
            case 3: {
                Lucene50CompressingStoredFieldsReader.readZFloat(in);
                break;
            }
            case 4: {
                Lucene50CompressingStoredFieldsReader.readTLong(in);
                break;
            }
            case 5: {
                Lucene50CompressingStoredFieldsReader.readZDouble(in);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    static float readZFloat(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        int bits = b << 24 | (in.readShort() & 0xFFFF) << 8 | in.readByte() & 0xFF;
        return Float.intBitsToFloat(bits);
    }

    static double readZDouble(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Double.longBitsToDouble(in.readLong());
        }
        if (b == 254) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        long bits = (long)b << 56 | ((long)in.readInt() & 0xFFFFFFFFL) << 24 | ((long)in.readShort() & 0xFFFFL) << 8 | (long)in.readByte() & 0xFFL;
        return Double.longBitsToDouble(bits);
    }

    static long readTLong(DataInput in) throws IOException {
        int header = in.readByte() & 0xFF;
        long bits = header & 0x1F;
        if ((header & 0x20) != 0) {
            bits |= in.readVLong() << 5;
        }
        long l = BitUtil.zigZagDecode(bits);
        switch (header & 0xC0) {
            case 64: {
                l *= 1000L;
                break;
            }
            case 128: {
                l *= 3600000L;
                break;
            }
            case 192: {
                l *= 86400000L;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return l;
    }

    SerializedDocument serializedDocument(int docID) throws IOException {
        if (!this.state.contains(docID)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(docID));
            this.state.reset(docID);
        }
        assert (this.state.contains(docID));
        return this.state.document(docID);
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        SerializedDocument doc = this.serializedDocument(docID);
        block5: for (int fieldIDX = 0; fieldIDX < doc.numStoredFields; ++fieldIDX) {
            long infoAndBits = doc.in.readVLong();
            int fieldNumber = (int)(infoAndBits >>> TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            int bits = (int)(infoAndBits & (long)TYPE_MASK);
            assert (bits <= 5) : "bits=" + Integer.toHexString(bits);
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    Lucene50CompressingStoredFieldsReader.readField(doc.in, visitor, fieldInfo, bits);
                    continue block5;
                }
                case NO: {
                    if (fieldIDX == doc.numStoredFields - 1) {
                        return;
                    }
                    Lucene50CompressingStoredFieldsReader.skipField(doc.in, bits);
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    @Override
    public StoredFieldsReader clone() {
        this.ensureOpen();
        return new Lucene50CompressingStoredFieldsReader(this, false);
    }

    @Override
    public StoredFieldsReader getMergeInstance() {
        this.ensureOpen();
        return new Lucene50CompressingStoredFieldsReader(this, true);
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.indexReader.checkIntegrity();
        CodecUtil.checksumEntireFile(this.fieldsStream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        private long[] offsets = LongsRef.EMPTY_LONGS;
        private long[] numStoredFields = LongsRef.EMPTY_LONGS;
        private long startPointer;
        private final BytesRef spare;
        private final BytesRef bytes;

        BlockState() {
            if (Lucene50CompressingStoredFieldsReader.this.merging) {
                this.spare = new BytesRef();
                this.bytes = new BytesRef();
            } else {
                this.bytes = null;
                this.spare = null;
            }
        }

        boolean contains(int docID) {
            return docID >= this.docBase && docID < this.docBase + this.chunkDocs;
        }

        void reset(int docID) throws IOException {
            boolean success = false;
            try {
                this.doReset(docID);
                success = true;
            }
            finally {
                if (!success) {
                    this.chunkDocs = 0;
                }
            }
        }

        private void doReset(int docID) throws IOException {
            this.docBase = Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int token = Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int n = this.chunkDocs = Lucene50CompressingStoredFieldsReader.this.version >= 4 ? token >>> 2 : token >>> 1;
            if (!this.contains(docID) || this.docBase + this.chunkDocs > Lucene50CompressingStoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: docID=" + docID + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + Lucene50CompressingStoredFieldsReader.this.numDocs, Lucene50CompressingStoredFieldsReader.this.fieldsStream);
            }
            this.sliced = (token & 1) != 0;
            this.offsets = ArrayUtil.grow(this.offsets, this.chunkDocs + 1);
            this.numStoredFields = ArrayUtil.grow(this.numStoredFields, this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int i;
                int bitsPerStoredFields = Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerStoredFields == 0) {
                    Arrays.fill(this.numStoredFields, 0, this.chunkDocs, (long)Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    LongsRef next;
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerStoredFields=" + bitsPerStoredFields, Lucene50CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(Lucene50CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, Lucene50CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, bitsPerStoredFields, 1024);
                    for (int i2 = 0; i2 < this.chunkDocs; i2 += next.length) {
                        next = it.next(Integer.MAX_VALUE);
                        System.arraycopy(next.longs, next.offset, this.numStoredFields, i2, next.length);
                    }
                }
                int bitsPerLength = Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerLength == 0) {
                    int length = Lucene50CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                    for (i = 0; i < this.chunkDocs; ++i) {
                        this.offsets[1 + i] = (long)(1 + i) * (long)length;
                    }
                } else {
                    LongsRef next;
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerLength=" + bitsPerLength, Lucene50CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(Lucene50CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, Lucene50CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, bitsPerLength, 1024);
                    for (i = 0; i < this.chunkDocs; i += next.length) {
                        next = it.next(Integer.MAX_VALUE);
                        System.arraycopy(next.longs, next.offset, this.offsets, i + 1, next.length);
                    }
                    for (i = 0; i < this.chunkDocs; ++i) {
                        int n2 = i + 1;
                        this.offsets[n2] = this.offsets[n2] + this.offsets[i];
                    }
                }
                for (int i3 = 0; i3 < this.chunkDocs; ++i3) {
                    long storedFields;
                    long len = this.offsets[i3 + 1] - this.offsets[i3];
                    if (len == 0L == ((storedFields = this.numStoredFields[i3]) == 0L)) continue;
                    throw new CorruptIndexException("length=" + len + ", numStoredFields=" + storedFields, Lucene50CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
            this.startPointer = Lucene50CompressingStoredFieldsReader.this.fieldsStream.getFilePointer();
            if (Lucene50CompressingStoredFieldsReader.this.merging) {
                int totalLength = Math.toIntExact(this.offsets[this.chunkDocs]);
                if (this.sliced) {
                    int toDecompress;
                    this.bytes.length = 0;
                    this.bytes.offset = 0;
                    for (int decompressed = 0; decompressed < totalLength; decompressed += toDecompress) {
                        toDecompress = Math.min(totalLength - decompressed, Lucene50CompressingStoredFieldsReader.this.chunkSize);
                        Lucene50CompressingStoredFieldsReader.this.decompressor.decompress(Lucene50CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, this.spare);
                        this.bytes.bytes = ArrayUtil.grow(this.bytes.bytes, this.bytes.length + this.spare.length);
                        System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                        this.bytes.length += this.spare.length;
                    }
                } else {
                    Lucene50CompressingStoredFieldsReader.this.decompressor.decompress(Lucene50CompressingStoredFieldsReader.this.fieldsStream, totalLength, 0, totalLength, this.bytes);
                }
                if (this.bytes.length != totalLength) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + totalLength + ", got " + this.bytes.length, Lucene50CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
        }

        SerializedDocument document(int docID) throws IOException {
            DataInput documentInput;
            if (!this.contains(docID)) {
                throw new IllegalArgumentException();
            }
            int index = docID - this.docBase;
            int offset = Math.toIntExact(this.offsets[index]);
            final int length = Math.toIntExact(this.offsets[index + 1]) - offset;
            int totalLength = Math.toIntExact(this.offsets[this.chunkDocs]);
            int numStoredFields = Math.toIntExact(this.numStoredFields[index]);
            final BytesRef bytes = Lucene50CompressingStoredFieldsReader.this.merging ? this.bytes : new BytesRef();
            if (length == 0) {
                documentInput = new ByteArrayDataInput();
            } else if (Lucene50CompressingStoredFieldsReader.this.merging) {
                documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset + offset, length);
            } else if (this.sliced) {
                Lucene50CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                Lucene50CompressingStoredFieldsReader.this.decompressor.decompress(Lucene50CompressingStoredFieldsReader.this.fieldsStream, Lucene50CompressingStoredFieldsReader.this.chunkSize, offset, Math.min(length, Lucene50CompressingStoredFieldsReader.this.chunkSize - offset), bytes);
                documentInput = new DataInput(){
                    int decompressed;
                    {
                        this.decompressed = bytes.length;
                    }

                    void fillBuffer() throws IOException {
                        assert (this.decompressed <= length);
                        if (this.decompressed == length) {
                            throw new EOFException();
                        }
                        int toDecompress = Math.min(length - this.decompressed, Lucene50CompressingStoredFieldsReader.this.chunkSize);
                        Lucene50CompressingStoredFieldsReader.this.decompressor.decompress(Lucene50CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, bytes);
                        this.decompressed += toDecompress;
                    }

                    @Override
                    public byte readByte() throws IOException {
                        if (bytes.length == 0) {
                            this.fillBuffer();
                        }
                        --bytes.length;
                        return bytes.bytes[bytes.offset++];
                    }

                    @Override
                    public void readBytes(byte[] b, int offset, int len) throws IOException {
                        while (len > bytes.length) {
                            System.arraycopy(bytes.bytes, bytes.offset, b, offset, bytes.length);
                            len -= bytes.length;
                            offset += bytes.length;
                            this.fillBuffer();
                        }
                        System.arraycopy(bytes.bytes, bytes.offset, b, offset, len);
                        bytes.offset += len;
                        bytes.length -= len;
                    }

                    @Override
                    public void skipBytes(long numBytes) throws IOException {
                        if (numBytes < 0L) {
                            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
                        }
                        while (numBytes > (long)bytes.length) {
                            numBytes -= (long)bytes.length;
                            this.fillBuffer();
                        }
                        bytes.offset = (int)((long)bytes.offset + numBytes);
                        bytes.length = (int)((long)bytes.length - numBytes);
                    }
                };
            } else {
                Lucene50CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                Lucene50CompressingStoredFieldsReader.this.decompressor.decompress(Lucene50CompressingStoredFieldsReader.this.fieldsStream, totalLength, offset, length, bytes);
                assert (bytes.length == length);
                documentInput = new ByteArrayDataInput(bytes.bytes, bytes.offset, bytes.length);
            }
            return new SerializedDocument(EndiannessReverserUtil.wrapDataInput(documentInput), length, numStoredFields);
        }
    }

    static class SerializedDocument {
        final DataInput in;
        final int length;
        final int numStoredFields;

        private SerializedDocument(DataInput in, int length, int numStoredFields) {
            this.in = in;
            this.length = length;
            this.numStoredFields = numStoredFields;
        }
    }
}

