/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;

public final class StemmerOverrideFilter
extends TokenFilter {
    private final StemmerOverrideMap stemmerOverrideMap;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);
    private final FST.BytesReader fstReader;
    private final FST.Arc<BytesRef> scratchArc = new FST.Arc();
    private char[] spare = new char[0];

    public StemmerOverrideFilter(TokenStream input, StemmerOverrideMap stemmerOverrideMap) {
        super(input);
        this.stemmerOverrideMap = stemmerOverrideMap;
        this.fstReader = stemmerOverrideMap.getBytesReader();
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            BytesRef stem;
            if (this.fstReader == null) {
                return true;
            }
            if (!this.keywordAtt.isKeyword() && (stem = this.stemmerOverrideMap.get(this.termAtt.buffer(), this.termAtt.length(), this.scratchArc, this.fstReader)) != null) {
                this.spare = ArrayUtil.grow(this.termAtt.buffer(), stem.length);
                int length = UnicodeUtil.UTF8toUTF16(stem, this.spare);
                if (this.spare != this.termAtt.buffer()) {
                    this.termAtt.copyBuffer(this.spare, 0, length);
                } else {
                    this.termAtt.setLength(length);
                }
                this.keywordAtt.setKeyword(true);
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        private final BytesRefHash hash = new BytesRefHash();
        private final BytesRefBuilder spare = new BytesRefBuilder();
        private final ArrayList<CharSequence> outputValues = new ArrayList();
        private final boolean ignoreCase;
        private final CharsRefBuilder charsSpare = new CharsRefBuilder();

        public Builder() {
            this(false);
        }

        public Builder(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        public boolean add(CharSequence input, CharSequence output) {
            int length = input.length();
            if (this.ignoreCase) {
                this.charsSpare.grow(length);
                char[] buffer = this.charsSpare.chars();
                for (int i = 0; i < length; i += Character.toChars(Character.toLowerCase(Character.codePointAt(input, i)), buffer, i)) {
                }
                this.spare.copyChars(buffer, 0, length);
            } else {
                this.spare.copyChars(input, 0, length);
            }
            if (this.hash.add(this.spare.get()) >= 0) {
                this.outputValues.add(output);
                return true;
            }
            return false;
        }

        public StemmerOverrideMap build() throws IOException {
            ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
            FSTCompiler<BytesRef> fstCompiler = new FSTCompiler.Builder<BytesRef>(FST.INPUT_TYPE.BYTE4, outputs).build();
            int[] sort = this.hash.sort();
            IntsRefBuilder intsSpare = new IntsRefBuilder();
            int size = this.hash.size();
            BytesRef spare = new BytesRef();
            for (int i = 0; i < size; ++i) {
                int id = sort[i];
                BytesRef bytesRef = this.hash.get(id, spare);
                intsSpare.copyUTF8Bytes(bytesRef);
                fstCompiler.add(intsSpare.get(), new BytesRef(this.outputValues.get(id)));
            }
            return new StemmerOverrideMap(fstCompiler.compile(), this.ignoreCase);
        }
    }

    public static final class StemmerOverrideMap {
        private final FST<BytesRef> fst;
        private final boolean ignoreCase;

        public StemmerOverrideMap(FST<BytesRef> fst, boolean ignoreCase) {
            this.fst = fst;
            this.ignoreCase = ignoreCase;
        }

        public FST.BytesReader getBytesReader() {
            if (this.fst == null) {
                return null;
            }
            return this.fst.getBytesReader();
        }

        public BytesRef get(char[] buffer, int bufferLen, FST.Arc<BytesRef> scratchArc, FST.BytesReader fstReader) throws IOException {
            int codePoint;
            BytesRef pendingOutput = (BytesRef)this.fst.outputs.getNoOutput();
            BytesRef matchOutput = null;
            this.fst.getFirstArc(scratchArc);
            for (int bufUpto = 0; bufUpto < bufferLen; bufUpto += Character.charCount(codePoint)) {
                codePoint = Character.codePointAt(buffer, bufUpto, bufferLen);
                if (this.fst.findTargetArc(this.ignoreCase ? Character.toLowerCase(codePoint) : codePoint, scratchArc, scratchArc, fstReader) == null) {
                    return null;
                }
                pendingOutput = this.fst.outputs.add(pendingOutput, scratchArc.output());
            }
            if (scratchArc.isFinal()) {
                matchOutput = this.fst.outputs.add(pendingOutput, scratchArc.nextFinalOutput());
            }
            return matchOutput;
        }
    }
}

