/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.nodetable;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.io.BlockUTF8;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapZero;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.riot.web.LangTag;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.store.nodetable.DecoderSSE;
import org.apache.jena.tdb1.store.nodetable.Nodec;

public class NodecSSE
implements Nodec {
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};
    private static final PrefixMap pmap0 = PrefixMapZero.empty;
    private static final boolean onlySafeBNodeLabels = false;
    private static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerExceptionOnError();

    @Override
    public int maxSize(Node node) {
        return NodecSSE.maxLength(node);
    }

    @Override
    public int encode(Node node, ByteBuffer bb, PrefixMapping pmap) {
        if (!node.isConcrete()) {
            FmtLog.warn(TDB1.logInfo, "Attempt to encode non-concrete node: " + node, new Object[0]);
        }
        Object str2 = null;
        if (node.isURI()) {
            String x = StrUtils.encodeHex(node.getURI(), '_', invalidIRIChars);
            if (x != node.getURI()) {
                node = NodeFactory.createURI(x);
            }
        } else if (node.isLiteral() && NodeUtils.isLangString(node)) {
            String lang = node.getLiteralLanguage();
            if (!LangTag.check(lang)) {
                throw new TDB1Exception("bad language tag: " + node);
            }
        } else if (node.isBlank()) {
            str2 = "_:" + node.getBlankNodeLabel();
        } else if (node.isNodeTriple()) {
            str2 = NodeFmtLib.strNT(node);
        }
        if (str2 == null) {
            str2 = NodeFmtLib.strNT(node);
        }
        BlockUTF8.fromChars((CharSequence)str2, bb);
        bb.flip();
        return bb.limit();
    }

    @Override
    public Node decode(ByteBuffer bb, PrefixMapping pmap) {
        String str2 = BlockUTF8.toString(bb);
        if (str2.startsWith("_:")) {
            str2 = str2.substring(2);
            return NodeFactory.createBlankNode(str2);
        }
        if (str2.startsWith("<<")) {
            return DecoderSSE.parseNode(str2);
        }
        if (str2.startsWith("<")) {
            str2 = str2.substring(1, str2.length() - 1);
            str2 = StrUtils.unescapeString(str2);
            str2 = StrUtils.decodeHex(str2, '_');
            return NodeFactory.createURI(str2);
        }
        Tokenizer tokenizer = NodecSSE.createTokenizer(str2);
        if (!tokenizer.hasNext()) {
            throw new TDB1Exception("Failed to tokenize: " + str2);
        }
        Token t2 = tokenizer.next();
        try {
            Node n = t2.asNode();
            if (n == null) {
                throw new TDB1Exception("Not a node: " + str2);
            }
            return n;
        }
        catch (RiotException ex) {
            throw new TDB1Exception("Bad string for node: " + str2);
        }
    }

    private static Tokenizer createTokenizer(String string) {
        return TokenizerText.create().fromString(string).errorHandler(errorHandler).build();
    }

    private static int maxLength(Node node) {
        if (node.isBlank()) {
            return 2 + NodecSSE.maxLength(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            return 2 + NodecSSE.maxLength(node.getURI());
        }
        if (node.isLiteral()) {
            int len = 2 + NodecSSE.maxLength(node.getLiteralLexicalForm());
            if (NodeUtils.isLangString(node)) {
                len = len + 3 + node.getLiteralLanguage().length();
            } else if (!NodeUtils.isSimpleString(node)) {
                len = len + 4 + NodecSSE.maxLength(node.getLiteralDatatypeURI());
            }
            return len;
        }
        if (node.isVariable()) {
            return 1 + NodecSSE.maxLength(node.getName());
        }
        if (node.isNodeTriple()) {
            Triple t2 = node.getTriple();
            return 8 + NodecSSE.maxLength(t2.getSubject()) + NodecSSE.maxLength(t2.getPredicate()) + NodecSSE.maxLength(t2.getObject());
        }
        throw new TDB1Exception("Unrecognized node type: " + node);
    }

    private static int maxLength(String string) {
        if (string.indexOf(65533) >= 0) {
            return string.length() * 6;
        }
        return string.length() * 3;
    }
}

