/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.nodetable;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.tdb1.TDB1Exception;

class DecoderSSE {
    private static final Token tokenEOF = new Token(TokenType.EOF);

    DecoderSSE() {
    }

    protected static Node parseNode(String str2) {
        Tokenizer tokens2 = TokenizerText.fromString(str2);
        return DecoderSSE.parseNode(tokens2);
    }

    protected static Node parseNode(Tokenizer tokens2) {
        Token token = DecoderSSE.nextToken(tokens2);
        if (token.hasType(TokenType.LT2)) {
            return DecoderSSE.parseTripleTerm(tokens2);
        }
        return DecoderSSE.tokenAsNode(token);
    }

    protected static Node parseTripleTerm(Tokenizer tokens2) {
        Triple t2 = DecoderSSE.parseTriple(tokens2);
        Token x = DecoderSSE.nextToken(tokens2);
        if (x.getType() != TokenType.GT2) {
            DecoderSSE.exception(x, "Triple term not terminated by >>: %s");
        }
        return NodeFactory.createTripleNode(t2);
    }

    protected static Triple parseTriple(Tokenizer tokens2) {
        Token sToken = DecoderSSE.nextToken(tokens2);
        if (sToken.isEOF()) {
            DecoderSSE.exception(sToken, "Premature end of file: %s");
        }
        Node s2 = sToken.hasType(TokenType.LT2) ? DecoderSSE.parseTripleTerm(tokens2) : DecoderSSE.tokenAsNode(sToken);
        Token pToken = DecoderSSE.nextToken(tokens2);
        if (pToken.isEOF()) {
            DecoderSSE.exception(pToken, "Premature end of file: %s");
        }
        Node p = DecoderSSE.tokenAsNode(pToken);
        Token oToken = DecoderSSE.nextToken(tokens2);
        if (oToken.isEOF()) {
            DecoderSSE.exception(oToken, "Premature end of file: %s");
        }
        Node o = oToken.hasType(TokenType.LT2) ? DecoderSSE.parseTripleTerm(tokens2) : DecoderSSE.tokenAsNode(oToken);
        return Triple.create(s2, p, o);
    }

    private static void exception(Token token, String string) {
        String msg = string;
        if (token != null) {
            msg = String.format(string, token);
        }
        throw new TDB1Exception(msg);
    }

    private static Node tokenAsNode(Token token) {
        if (token.isBNode()) {
            String id = token.getImage();
            id = NodeFmtLib.decodeBNodeLabel(id);
            return NodeFactory.createBlankNode(id);
        }
        return token.asNode();
    }

    private static final Token nextToken(Tokenizer tokens2) {
        if (tokens2.eof()) {
            return tokenEOF;
        }
        try {
            Token t2 = tokens2.next();
            return t2;
        }
        catch (RiotParseException ex) {
            DecoderSSE.exception(null, ex.getMessage());
            throw ex;
        }
        catch (AtlasException ex) {
            DecoderSSE.exception(null, ex.getMessage());
            throw ex;
        }
    }
}

