/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb1.lib.TupleLib;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.TableBase;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;
import org.apache.jena.tdb1.sys.DatasetControl;

public class QuadTable
extends TableBase {
    public QuadTable(TupleIndex[] indexes, NodeTable nodeTable, DatasetControl policy) {
        super(4, indexes, nodeTable, policy);
    }

    public boolean add(Quad quad) {
        return this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean add(Node gn, Triple triple) {
        return this.add(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean add(Node g2, Node s2, Node p, Node o) {
        return this.table.addRow(g2, s2, p, o);
    }

    public boolean delete(Quad quad) {
        return this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public boolean delete(Node gn, Triple triple) {
        return this.delete(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean delete(Node g2, Node s2, Node p, Node o) {
        return this.table.deleteRow(g2, s2, p, o);
    }

    public Iterator<Quad> find(Node g2, Node s2, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(g2, s2, p, o);
        if (iter == null) {
            return new NullIterator<Quad>();
        }
        Iterator<Quad> iter2 = TupleLib.convertToQuads(this.table.getNodeTable(), iter);
        return iter2;
    }

    public void clearQuads() {
        this.table.clear();
    }
}

