/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.lib;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.ByteBufferLib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.block.Block;
import org.apache.jena.tdb1.base.block.BlockMgr;
import org.apache.jena.tdb1.index.bplustree.BPlusTree;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.DatasetPrefixesTDB;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;
import org.apache.jena.tdb1.store.tupletable.TupleTable;

public class DumpOps {
    public static void dump(Dataset ds) {
        DatasetGraphTDB dsg = (DatasetGraphTDB)ds.asDatasetGraph();
        NodeTupleTable nodeTupleTableTriples = dsg.getTripleTable().getNodeTupleTable();
        NodeTupleTable nodeTupleTableQuads = dsg.getQuadTable().getNodeTupleTable();
        if (nodeTupleTableTriples.getNodeTable() != nodeTupleTableQuads.getNodeTable()) {
            throw new TDB1Exception("Different node tables for triples and quads");
        }
        NodeTable nodeTable = nodeTupleTableTriples.getNodeTable();
        HashSet<NodeTable> dumpedNodeTables = new HashSet<NodeTable>();
        System.out.print("## Node Table\n");
        DumpOps.dumpNodeTable(nodeTupleTableTriples.getNodeTable(), dumpedNodeTables);
        DumpOps.dumpNodeTable(nodeTupleTableQuads.getNodeTable(), dumpedNodeTables);
        DumpOps.dumpTupleIndexes(nodeTupleTableTriples.getTupleTable().getIndexes());
        DumpOps.dumpTupleIndexes(nodeTupleTableQuads.getTupleTable().getIndexes());
        System.out.print("## Prefix Table\n");
        DatasetPrefixesTDB prefixes = dsg.getStoragePrefixes();
        NodeTupleTable pntt = prefixes.getNodeTupleTable();
        if (!dumpedNodeTables.contains(pntt.getNodeTable())) {
            DumpOps.dumpNodeTable(pntt.getNodeTable(), dumpedNodeTables);
            dumpedNodeTables.add(pntt.getNodeTable());
        }
        DumpOps.dumpTupleIndexes(prefixes.getNodeTupleTable().getTupleTable().getIndexes());
    }

    public static void dumpNodeTable(NodeTable nodeTable, Set<NodeTable> dumpedNodeTables) {
        if (dumpedNodeTables.contains(nodeTable)) {
            return;
        }
        Iterator<Pair<NodeId, Node>> iter = nodeTable.all();
        while (iter.hasNext()) {
            Pair<NodeId, Node> pair = iter.next();
            NodeId nid = pair.car();
            Node n = pair.cdr();
            String x = NodeFmtLib.displayStr(n);
            System.out.printf("%016X %s\n", nid.getId(), x);
        }
        dumpedNodeTables.add(nodeTable);
    }

    public static void dumpTupleIndexes(TupleIndex[] tupleIndexes) {
        for (TupleIndex tIdx : tupleIndexes) {
            DumpOps.dumpTupleIndex(tIdx);
        }
    }

    public static void dumpTupleIndex(TupleIndex tIdx) {
        System.out.print("## " + tIdx.getMappingStr() + "\n");
        Iterator<Tuple<NodeId>> iter = tIdx.all();
        while (iter.hasNext()) {
            Tuple<NodeId> t2 = iter.next();
            System.out.print(t2);
            System.out.print("\n");
        }
    }

    public static void dumpBlockMgr(PrintStream out, BlockMgr blkMgr) {
        try {
            for (int id = 0; id < 9999999 && blkMgr.valid(id); ++id) {
                Block blk = blkMgr.getRead(id);
                out.print("id=" + blk.getId() + "  ");
                ByteBufferLib.print(out, blk.getByteBuffer());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dumpBPlusTree(PrintStream out, BPlusTree bpt) {
        IndentedWriter iw = new IndentedWriter(out);
        bpt.dump(iw);
    }

    public static void dumpBPlusTreeBlocks(BPlusTree bpt) {
        System.out.println("Data blocks");
        DumpOps.dumpBlockMgr(System.out, bpt.getRecordsMgr().getBlockMgr());
        System.out.println("Node blocks");
        DumpOps.dumpBlockMgr(System.out, bpt.getRecordsMgr().getBlockMgr());
    }

    public static void dumpNodeTupleTable(TupleTable tupleTable) {
        int N2 = tupleTable.getTupleLen();
        Object[] nodeIds = new NodeId[N2];
        Arrays.fill(nodeIds, NodeId.NodeIdAny);
        Tuple<Object> t2 = TupleFactory.asTuple(nodeIds);
        Iterator<Tuple<NodeId>> iter = tupleTable.find(t2);
        while (iter.hasNext()) {
            Tuple<NodeId> tuple = iter.next();
            System.out.print(tuple);
            System.out.print("\n");
        }
    }
}

