/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.index.bplustree;

import org.apache.jena.tdb1.base.block.Block;
import org.apache.jena.tdb1.base.block.BlockConverter;
import org.apache.jena.tdb1.base.block.BlockType;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.base.recordbuffer.RecordBufferPage;
import org.apache.jena.tdb1.base.recordbuffer.RecordBufferPageMgr;
import org.apache.jena.tdb1.index.bplustree.BPTreePageMgr;
import org.apache.jena.tdb1.index.bplustree.BPTreeRecords;
import org.apache.jena.tdb1.index.bplustree.BPlusTree;

public final class BPTreeRecordsMgr
extends BPTreePageMgr<BPTreeRecords> {
    private RecordBufferPageMgr rBuffPageMgr;

    BPTreeRecordsMgr(BPlusTree bpTree, RecordBufferPageMgr rBuffPageMgr) {
        super(bpTree, null, rBuffPageMgr.getBlockMgr());
        this.rBuffPageMgr = rBuffPageMgr;
        super.setConverter(new Block2BPTreeRecords(bpTree, bpTree.getRecordFactory()));
    }

    public BPTreeRecords create() {
        return (BPTreeRecords)super.create(BlockType.RECORD_BLOCK);
    }

    public RecordBufferPageMgr getRecordBufferPageMgr() {
        return this.rBuffPageMgr;
    }

    @Override
    public void startRead() {
        this.rBuffPageMgr.startRead();
    }

    @Override
    public void finishRead() {
        this.rBuffPageMgr.finishRead();
    }

    @Override
    public void startUpdate() {
        this.rBuffPageMgr.startUpdate();
    }

    @Override
    public void finishUpdate() {
        this.rBuffPageMgr.finishUpdate();
    }

    static class Block2BPTreeRecords
    implements BlockConverter<BPTreeRecords> {
        private RecordBufferPageMgr.Block2RecordBufferPage recordBufferConverter;
        private BPlusTree bpTree;

        Block2BPTreeRecords(BPlusTree bpTree, RecordFactory recordFactory) {
            this.bpTree = bpTree;
            this.recordBufferConverter = new RecordBufferPageMgr.Block2RecordBufferPage(recordFactory);
        }

        @Override
        public BPTreeRecords fromBlock(Block block) {
            RecordBufferPage rbp = this.recordBufferConverter.fromBlock(block);
            return new BPTreeRecords(this.bpTree, rbp);
        }

        @Override
        public Block toBlock(BPTreeRecords t2) {
            return this.recordBufferConverter.toBlock(t2.getRecordBufferPage());
        }

        @Override
        public BPTreeRecords createFromBlock(Block block, BlockType bType) {
            RecordBufferPage rbp = this.recordBufferConverter.createFromBlock(block, bType);
            return new BPTreeRecords(this.bpTree, rbp);
        }
    }
}

