/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.syntax.PatternVars;

public class SyntaxVarScope {
    public static void check(Query query2) {
        if (query2.getQueryPattern() == null) {
            return;
        }
        SyntaxVarScope.check(query2.getQueryPattern());
        SyntaxVarScope.checkQueryScope(query2);
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query2);
        SyntaxVarScope.check(query2, vars);
    }

    public static void check(Element queryPattern) {
        SyntaxVarScope.checkSubQuery(queryPattern);
        SyntaxVarScope.checkPatternAssign(queryPattern);
    }

    private static void checkPatternAssign(Element queryPattern) {
        VarScopeChecker v = new VarScopeChecker();
        ElementWalker.walk(queryPattern, v);
    }

    private static void checkSubQuery(Element el) {
        SubQueryScopeChecker v = new SubQueryScopeChecker();
        ElementWalker.walk(el, v);
    }

    private static void checkQueryScope(Query query2) {
        Collection<Var> vars = SyntaxVarScope.varsOfQuery(query2);
        SyntaxVarScope.checkExprListAssignment(vars, query2.getProject());
    }

    private static Collection<Var> varsOfQuery(Query query2) {
        Collection<Var> vars = PatternVars.vars(query2.getQueryPattern());
        if (query2.hasValues()) {
            vars.addAll(query2.getValuesVariables());
        }
        return vars;
    }

    private static void check(Query query2, Collection<Var> vars) {
        SyntaxVarScope.checkExprListAssignment(vars, query2.getProject());
        if (!Syntax.syntaxARQ.equals(query2.getSyntax()) && query2.isQueryResultStar() && query2.hasGroupBy()) {
            throw new QueryParseException("SELECT * not legal with GROUP BY", -1, -1);
        }
        SyntaxVarScope.checkExprVarUse(query2);
    }

    private static void checkExprListAssignment(Collection<Var> vars, VarExprList exprList) {
        LinkedHashSet<Var> vars2 = new LinkedHashSet<Var>(vars);
        exprList.forEachExpr((v, e2) -> {
            Set<Var> varInExpr = e2.getVarsMentioned();
            vars2.addAll(varInExpr);
            SyntaxVarScope.checkExpr(vars2, e2, v);
            vars2.add((Var)v);
        });
    }

    private static void checkExprVarUse(Query query2) {
        if (query2.hasGroupBy()) {
            VarExprList groupKey = query2.getGroupBy();
            ArrayList<Var> inScopeVars = new ArrayList<Var>(groupKey.getVars());
            VarExprList exprList = query2.getProject();
            for (Var v : exprList.getVars()) {
                Expr e2 = exprList.getExpr(v);
                if (e2 == null) {
                    if (!inScopeVars.contains(v)) {
                        throw new QueryParseException("Non-group key variable in SELECT: " + v, -1, -1);
                    }
                } else {
                    Set<Var> eVars = e2.getVarsMentioned();
                    for (Var v2 : eVars) {
                        if (inScopeVars.contains(v2)) continue;
                        throw new QueryParseException("Non-group key variable in SELECT: " + v2 + " in expression " + e2, -1, -1);
                    }
                }
                inScopeVars.add(v);
            }
        }
    }

    private static void checkExpr(Collection<Var> scope, Expr expr, Var var) {
        if (expr == null) {
            return;
        }
        if (scope.contains(var)) {
            throw new QueryParseException("Variable used when already in-scope: " + var + " in " + SyntaxVarScope.fmtAssignment(expr, var), -1, -1);
        }
    }

    private static String fmtExprList(VarExprList exprList) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Var v : exprList.getVars()) {
            Expr e2 = exprList.getExpr(v);
            if (!first) {
                sb.append(" ");
            }
            first = false;
            sb.append("(").append(e2).append(" AS ").append(v).append(")");
        }
        return sb.toString();
    }

    private static String fmtAssignment(Expr expr, Var var) {
        return "(" + expr + " AS " + var + ")";
    }

    public static class VarScopeChecker
    extends ElementVisitorBase {
        VarScopeChecker() {
        }

        @Override
        public void visit(ElementGroup el) {
            for (int i = 0; i < el.size(); ++i) {
                Collection<Var> accScope;
                Element e2 = el.get(i);
                if (e2 instanceof ElementBind) {
                    ElementBind eltBind = (ElementBind)e2;
                    accScope = VarScopeChecker.calcScopeAll(el.getElements(), i);
                    VarScopeChecker.checkBIND(accScope, eltBind);
                }
                if (e2 instanceof ElementService) {
                    ElementService eltSvc = (ElementService)e2;
                    accScope = VarScopeChecker.calcScopeAll(el.getElements(), i);
                    VarScopeChecker.checkSERVICE(accScope, eltSvc);
                }
                if (!(e2 instanceof ElementLateral)) continue;
                ElementLateral eltLat = (ElementLateral)e2;
                accScope = VarScopeChecker.calcScopeAll(el.getElements(), i);
                this.checkLATERAL(accScope, eltLat);
            }
        }

        private static Collection<Var> calcScopeAll(List<Element> elements, int idx) {
            return VarScopeChecker.calcScope(elements, 0, idx);
        }

        private static Collection<Var> calcScope(List<Element> elements, int start, int finish) {
            HashSet<Var> accScope = new HashSet<Var>();
            for (int i = start; i < finish; ++i) {
                Element e2 = elements.get(i);
                PatternVars.vars(accScope, e2);
            }
            return accScope;
        }

        private static void checkBIND(Collection<Var> scope, ElementBind el) {
            Var var = el.getVar();
            if (scope.contains(var)) {
                throw new QueryParseException("BIND: Variable used when already in-scope: " + var + " in " + el, -1, -1);
            }
            SyntaxVarScope.checkExpr(scope, el.getExpr(), var);
        }

        private static void checkSERVICE(Collection<Var> scope, ElementService el) {
            Var var;
            if (ARQ.isStrictMode() && el.getServiceNode().isVariable() && !scope.contains(var = Var.alloc(el.getServiceNode()))) {
                throw new QueryParseException("SERVICE: Variable not already in-scope: " + var + " in " + el, -1, -1);
            }
        }

        private void checkLATERAL(final Collection<Var> accScope, Element el) {
            ElementVisitorBase checker = new ElementVisitorBase(){

                @Override
                public void visit(ElementBind eltBind) {
                    if (accScope.contains(eltBind.getVar())) {
                        throw new QueryParseException("BIND: Variable " + eltBind.getVar() + " defined", -1, -1);
                    }
                }

                @Override
                public void visit(ElementData eltData) {
                    eltData.getVars().forEach(v -> {
                        if (accScope.contains(v)) {
                            throw new QueryParseException("VALUES: Variable " + v + " defined", -1, -1);
                        }
                    });
                }

                @Override
                public void visit(ElementSubQuery eltSubQuery) {
                    eltSubQuery.getQuery().getProject().forEachExpr((var, expr) -> {
                        if (accScope.contains(var)) {
                            throw new QueryParseException("SELECT: Variable " + var + " defined", -1, -1);
                        }
                    });
                    Query subQuery = eltSubQuery.getQuery();
                    ArrayList<Var> accScope2 = accScope;
                    if (!subQuery.isQueryResultStar()) {
                        List<Var> projectVars = eltSubQuery.getQuery().getProject().getVars();
                        accScope2 = new ArrayList<Var>(accScope);
                        accScope2.removeIf(v -> !projectVars.contains(v));
                    }
                    if (accScope2.isEmpty()) {
                        return;
                    }
                    Element el2 = eltSubQuery.getQuery().getQueryPattern();
                    this.checkLATERAL(accScope2, el2);
                }
            };
            ElementWalker.walk(el, checker);
        }
    }

    private static class SubQueryScopeChecker
    extends ElementVisitorBase {
        private SubQueryScopeChecker() {
        }

        @Override
        public void visit(ElementSubQuery el) {
            Query query2 = el.getQuery();
            SyntaxVarScope.checkQueryScope(query2);
            SyntaxVarScope.check(el.getQuery());
        }
    }
}

