/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class NodeConst {
    public static final Node nodeTrue = NodeConst.literal("true", XSDDatatype.XSDboolean);
    public static final Node nodeFalse = NodeConst.literal("false", XSDDatatype.XSDboolean);
    public static final Node nodeZero = NodeConst.literal("0", XSDDatatype.XSDinteger);
    public static final Node nodeOne = NodeConst.literal("1", XSDDatatype.XSDinteger);
    public static final Node nodeTwo = NodeConst.literal("2", XSDDatatype.XSDinteger);
    public static final Node nodeTen = NodeConst.literal("10", XSDDatatype.XSDinteger);
    public static final Node nodeMinusOne = NodeConst.literal("-1", XSDDatatype.XSDinteger);
    public static final Node emptyString = NodeFactory.createLiteralString("");
    public static final Node TRUE = nodeTrue;
    public static final Node FALSE = nodeFalse;
    public static final Node nodeRDFType = RDF.Nodes.type;
    public static final Node nodeFirst = RDF.Nodes.first;
    public static final Node nodeRest = RDF.Nodes.rest;
    public static final Node nodeNil = RDF.Nodes.nil;
    public static final Node nodeANY = Node.ANY;
    public static final Node nodeOwlImports = OWL.imports.asNode();
    public static final Node nodeOwlOntology = OWL.Ontology.asNode();
    public static final Node nodeOwlSameAs = OWL.sameAs.asNode();
    public static final Node rdfLangString = RDF.Nodes.langString;
    public static final RDFDatatype dtLangString = RDF.dtLangString;
    public static Literal mTRUE = ResourceFactory.createTypedLiteral(true);
    public static Literal mFALSE = ResourceFactory.createTypedLiteral(false);
    public static Node rdfsClass = RDFS.Nodes.Class;
    public static Node rdfsSubclassOf = RDFS.subClassOf.asNode();
    public static final Node FIRST = RDF.first.asNode();
    public static final Node REST = RDF.rest.asNode();
    public static final Node NIL = RDF.nil.asNode();

    private static Node literal(String lex, RDFDatatype dt) {
        return NodeFactory.createLiteral(lex, dt);
    }

    private static Node uri(String uriStr) {
        return NodeFactory.createURI(uriStr);
    }
}

