/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.scripting;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pool;
import org.apache.jena.atlas.lib.PoolBase;
import org.apache.jena.atlas.lib.PoolSync;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprUndefFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.scripting.NV;
import org.apache.jena.sparql.function.scripting.ScriptDenyException;
import org.apache.jena.sparql.function.scripting.ScriptLangSymbols;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class ScriptFunction
extends FunctionBase {
    private static final ScriptEngineManager scriptEngineManager;
    private static final String ARQ_NS = "http://jena.apache.org/ARQ/";
    private static final String FUNCTION_SUFFIX = "Function";
    private static final Map<String, Pool<Invocable>> enginePools;
    private String lang;
    private String name;
    private Set<String> allowList;
    private Set<String> denyList;

    private static void checkScriptingEnabled() {
        String x = System.getProperty("jena:scripting");
        boolean scriptingEnabled = "true".equals(x);
        if (!scriptingEnabled) {
            throw new ScriptDenyException("Scripting not enabled");
        }
    }

    public static boolean isScriptFunction(String uri) {
        if (!uri.startsWith(ARQ_NS)) {
            return false;
        }
        String localPart = uri.substring(ARQ_NS.length());
        int separatorPos = localPart.indexOf(35);
        if (separatorPos < 0) {
            return false;
        }
        String langPart = localPart.substring(0, separatorPos);
        return langPart.endsWith(FUNCTION_SUFFIX);
    }

    @Override
    public void checkBuild(String uri, ExprList args) {
        throw new IllegalStateException("ScriptFunction.checkBuild called");
    }

    @Override
    public void build(String uri, ExprList args, Context cxt) {
        String cname;
        ScriptFunction.checkScriptingEnabled();
        if (!ScriptFunction.isScriptFunction(uri)) {
            throw new ExprException("Invalid URI: " + uri);
        }
        String localPart = uri.substring(ARQ_NS.length());
        int separatorPos = localPart.indexOf(35);
        this.lang = localPart.substring(0, separatorPos - FUNCTION_SUFFIX.length());
        this.name = localPart.substring(separatorPos + 1);
        this.allowList = ScriptFunction.allowList(cxt, ARQ.symCustomFunctionScriptAllowList);
        switch (cname = Lib.lowercase(this.lang)) {
            case "js": {
                this.denyList = Set.of("eval", "load");
                ScriptFunction.check(this.lang, this.name, this.allowList, this.denyList);
                break;
            }
            default: {
                throw new ScriptDenyException("Language '" + this.lang + "' not recognized");
            }
        }
    }

    private static Set<String> allowList(Context cxt, Symbol symScriptAllowList) {
        String x = (String)cxt.get(symScriptAllowList);
        if (x == null) {
            return Set.of();
        }
        String[] x2 = x.split(",");
        return Set.of(x2);
    }

    private static void check(String lang, String name, Set<String> allowList, Set<String> denyList) {
        if (name == null) {
            throw new ExprException("No function name");
        }
        if (denyList.contains(name)) {
            throw new ScriptDenyException("Function '" + name + "' not allowed");
        }
        if (!allowList.contains(name)) {
            throw new ScriptDenyException("Function '" + name + "' not in the list of allowed functions");
        }
    }

    @Override
    public NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        env.getContext();
        return this.exec(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeValue exec(List<NodeValue> args) {
        ScriptFunction.checkScriptingEnabled();
        Invocable engine = this.getEngine();
        try {
            Object r;
            Object[] params = args.stream().map(NV::fromNodeValue).toArray();
            try {
                r = engine.invokeFunction(this.name, params);
            }
            catch (ScriptException e2) {
                throw new ExprEvalException("Failed to evaluate " + this.lang + "function '" + this.name + "'", e2);
            }
            catch (NoSuchMethodException e3) {
                throw new ExprUndefFunction("No such " + this.lang + " function '" + this.name + "'", this.name);
            }
            if (r == null) {
                throw new ExprEvalException(this.name);
            }
            NodeValue nodeValue = NV.toNodeValue(r);
            return nodeValue;
        }
        finally {
            this.recycleEngine(engine);
        }
    }

    private Invocable getEngine() {
        Pool pool = enginePools.computeIfAbsent(this.lang, key -> PoolSync.create(new PoolBase()));
        Invocable engine = (Invocable)pool.get();
        if (engine == null) {
            engine = this.createEngine();
        }
        return engine;
    }

    private void recycleEngine(Invocable engine) {
        enginePools.get(this.lang).put(engine);
    }

    private Invocable createEngine() {
        String functions;
        ScriptEngine engine = scriptEngineManager.getEngineByName(this.lang);
        if (engine == null) {
            throw new ExprException("Unknown scripting language: " + this.lang);
        }
        if (engine.getFactory().getEngineName().equals("Graal.js")) {
            engine.getContext().setAttribute("polyglot.js.nashorn-compat", true, 100);
        }
        if (!(engine instanceof Invocable)) {
            throw new ExprException("Script engine  " + engine.getFactory().getEngineName() + " doesn't implement Invocable");
        }
        String functionLibFile = ARQ.getContext().getAsString(ScriptLangSymbols.scriptLibrary(this.lang));
        if (functionLibFile != null) {
            try (BufferedReader reader = Files.newBufferedReader(Path.of(functionLibFile, new String[0]), StandardCharsets.UTF_8);){
                engine.eval(reader);
            }
            catch (FileNotFoundException | NoSuchFileException ex) {
                throw new RiotNotFoundException("File: " + functionLibFile);
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
            catch (ScriptException e2) {
                throw new ExprException("Failed to load " + this.lang + " library", e2);
            }
        }
        if ((functions = ARQ.getContext().getAsString(ScriptLangSymbols.scriptFunctions(this.lang))) != null) {
            try {
                engine.eval(functions);
            }
            catch (ScriptException e3) {
                throw new ExprException("Failed to load " + this.lang + " functions", e3);
            }
        }
        Invocable invocable = (Invocable)((Object)engine);
        return invocable;
    }

    static void clearEngineCache() {
        enginePools.clear();
    }

    static {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        if (System.getProperty("nashorn.args") == null) {
            System.setProperty("nashorn.args", "--language=es6");
        }
        scriptEngineManager = new ScriptEngineManager();
        enginePools = new ConcurrentHashMap<String, Pool<Invocable>>();
    }
}

