/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.solver;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public class StageMatchTriple {
    public static Iterator<Binding> accessTriple(Iterator<Binding> input, Graph graph, Triple pattern, Predicate<Triple> filter, ExecutionContext execCxt) {
        if (!input.hasNext()) {
            return Iter.nullIterator();
        }
        return Iter.flatMap(input, binding -> StageMatchTriple.accessTriple(binding, graph, pattern, filter, execCxt));
    }

    private static Iterator<Binding> accessTriple(Binding binding, Graph graph, Triple pattern, Predicate<Triple> filter, ExecutionContext execCxt) {
        Node s2 = StageMatchTriple.substituteFlat(pattern.getSubject(), binding);
        Node p = StageMatchTriple.substituteFlat(pattern.getPredicate(), binding);
        Node o = StageMatchTriple.substituteFlat(pattern.getObject(), binding);
        BindingBuilder resultsBuilder = Binding.builder(binding);
        Node s22 = StageMatchTriple.tripleNode(s2);
        Node p2 = StageMatchTriple.tripleNode(p);
        Node o2 = StageMatchTriple.tripleNode(o);
        ExtendedIterator<Triple> graphIter = G.findByLang(graph, s22, p2, o2);
        ExtendedIterator<Binding> iter = graphIter.mapWith(r -> StageMatchTriple.mapper(resultsBuilder, s2, p, o, r)).filterDrop(Objects::isNull);
        return iter;
    }

    private static Node tripleNode(Node node) {
        if (node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    private static Binding mapper(BindingBuilder resultsBuilder, Node s2, Node p, Node o, Triple r) {
        resultsBuilder.reset();
        if (!StageMatchTriple.insert(resultsBuilder, s2, r.getSubject())) {
            return null;
        }
        if (!StageMatchTriple.insert(resultsBuilder, p, r.getPredicate())) {
            return null;
        }
        if (!StageMatchTriple.insert(resultsBuilder, o, r.getObject())) {
            return null;
        }
        return resultsBuilder.build();
    }

    private static boolean insert(BindingBuilder results, Node patternNode, Node dataNode) {
        if (!Var.isVar(patternNode)) {
            return true;
        }
        Var v = Var.alloc(patternNode);
        Node x = results.get(v);
        if (x != null) {
            return SolverLib.sameTermAs(dataNode, x);
        }
        results.add(v, dataNode);
        return true;
    }

    private static Node substituteFlat(Node n, Binding binding) {
        return Var.lookup(binding::get, n);
    }
}

