/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class Match {
    public static boolean match(Quad quad, Node g2, Node s2, Node p, Node o) {
        return Match.match(quad.getGraph(), g2) && Match.match(quad.getSubject(), s2) && Match.match(quad.getPredicate(), p) && Match.match(quad.getObject(), o);
    }

    public static boolean match(Triple triple, Node s2, Node p, Node o) {
        return Match.match(triple.getSubject(), s2) && Match.match(triple.getPredicate(), p) && Match.match(triple.getObject(), o);
    }

    public static boolean match(Node node, Node pattern) {
        return pattern == null || pattern == Node.ANY || pattern.equals(node);
    }

    public static boolean matchValue(Node node, Node pattern) {
        Objects.requireNonNull(node);
        return pattern == null || pattern == Node.ANY || pattern.sameValueAs(node);
    }

    public static Stream<Triple> match(Collection<Triple> triples, Node s2, Node p, Node o) {
        return triples.stream().filter(t2 -> Match.match(t2, s2, p, o));
    }

    public static Stream<Quad> match(Collection<Quad> quads, Node g2, Node s2, Node p, Node o) {
        return quads.stream().filter(q -> Match.match(q, g2, s2, p, o));
    }
}

