/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class BasicPattern
implements Iterable<Triple> {
    private List<Triple> triples;

    public BasicPattern() {
        this(new ArrayList<Triple>());
    }

    public BasicPattern(BasicPattern other) {
        this();
        this.triples.addAll(other.triples);
    }

    private BasicPattern(List<Triple> triples) {
        this.triples = triples;
    }

    public static BasicPattern wrap(List<Triple> triples) {
        return new BasicPattern(triples);
    }

    public void add(Triple t2) {
        this.triples.add(t2);
    }

    public void addAll(BasicPattern other) {
        this.triples.addAll(other.triples);
    }

    public void add(int i, Triple t2) {
        this.triples.add(i, t2);
    }

    public Triple get(int i) {
        return this.triples.get(i);
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.triples.listIterator();
    }

    public int size() {
        return this.triples.size();
    }

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public List<Triple> getList() {
        return this.triples;
    }

    public int hashCode() {
        return this.triples.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicPattern)) {
            return false;
        }
        BasicPattern bp = (BasicPattern)other;
        return this.triples.equals(bp.triples);
    }

    public boolean equiv(BasicPattern other, NodeIsomorphismMap isoMap) {
        if (this.triples.size() != other.triples.size()) {
            return false;
        }
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple t2;
            Triple t1 = this.get(i);
            if (Iso.tripleIso(t1, t2 = other.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        SerializationContext sCxt = SSE.sCxt(SSE.getPrefixMapString());
        boolean first = true;
        for (Triple t2 : this.triples) {
            if (!first) {
                out.print("\n");
            } else {
                first = false;
            }
            out.print("(");
            WriterNode.outputPlain((IndentedWriter)out, t2, sCxt);
            out.print(")");
        }
        out.flush();
        return out.toString();
    }
}

