/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.List;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpLib;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;

public class TransformPattern2Join
extends TransformCopy {
    @Override
    public Op transform(OpBGP opBGP) {
        return TransformPattern2Join.expand(opBGP.getPattern());
    }

    @Override
    public Op transform(OpQuadPattern quadPattern) {
        return TransformPattern2Join.expand(quadPattern.getPattern());
    }

    @Override
    public Op transform(OpSequence opSeq, List<Op> elts) {
        return TransformPattern2Join.expand(opSeq, elts);
    }

    private static Op expand(BasicPattern bgp) {
        if (bgp.getList().isEmpty()) {
            return OpLib.unit();
        }
        Op op = null;
        for (Triple t2 : bgp.getList()) {
            OpTriple x = new OpTriple(t2);
            op = TransformPattern2Join.join(op, x);
        }
        return op;
    }

    private static Op expand(QuadPattern quads) {
        if (quads.getList().isEmpty()) {
            return OpLib.unit();
        }
        Op op = null;
        for (Quad q : quads.getList()) {
            OpQuad x = new OpQuad(q);
            op = TransformPattern2Join.join(op, x);
        }
        return op;
    }

    private static Op expand(OpSequence opSeq, List<Op> elts) {
        Op x = null;
        for (Op op : elts) {
            x = TransformPattern2Join.join(x, op);
        }
        return x;
    }

    private static Op join(Op left, Op right) {
        return OpJoin.createReduce(left, right);
    }
}

