/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.path.PathVisitorBase;

public class TransformPathFlattenAlgebra
extends TransformCopy {
    private static VarAlloc varAlloc = new VarAlloc("?Q");

    public static void resetForTest() {
        varAlloc = new VarAlloc("?Q");
    }

    @Override
    public Op transform(OpPath opPath) {
        TriplePath tp = opPath.getTriplePath();
        Op op = TransformPathFlattenAlgebra.transformPath(opPath, tp.getSubject(), tp.getPath(), tp.getObject());
        return op;
    }

    static Op transformPath(OpPath op, Node subject, Path path, Node object) {
        PathTransform transform = new PathTransform(subject, object);
        path.visit(transform);
        Op r = transform.getResult();
        if (r == null) {
            if (op == null) {
                op = TransformPathFlattenAlgebra.make(subject, path, object);
            }
            return op;
        }
        return r;
    }

    static OpPath make(Node subject, Path path, Node object) {
        TriplePath tp = new TriplePath(subject, path, object);
        return new OpPath(tp);
    }

    private static Op join(Op op1, Op op2) {
        return OpJoin.create(op1, op2);
    }

    private static Op union(Op left, Op right) {
        return OpUnion.create(left, right);
    }

    private static class PathTransform
    extends PathVisitorBase {
        private final Node subject;
        private final Node object;
        private Op result = null;

        Op getResult() {
            return this.result;
        }

        public PathTransform(Node subject, Node object) {
            this.subject = subject;
            this.object = object;
            this.result = null;
        }

        @Override
        public void visit(P_Link pathNode) {
            OpTriple op = new OpTriple(Triple.create(this.subject, pathNode.getNode(), this.object));
            this.result = op;
        }

        @Override
        public void visit(P_ReverseLink pathNode) {
            OpTriple op = new OpTriple(Triple.create(this.object, pathNode.getNode(), this.subject));
            this.result = op;
        }

        @Override
        public void visit(P_NegPropSet pathNotOneOf) {
            OpPath opFwd = null;
            OpPath opBwd = null;
            ArrayList<P_Path0> forwards = new ArrayList<P_Path0>();
            ArrayList<P_Path0> backwards = new ArrayList<P_Path0>();
            for (P_Path0 p : pathNotOneOf.getNodes()) {
                if (p.isForward()) {
                    forwards.add(p);
                    continue;
                }
                backwards.add(p);
            }
            if (!forwards.isEmpty()) {
                P_NegPropSet pFwd = new P_NegPropSet();
                for (P_Path0 p : forwards) {
                    pFwd.add(p);
                }
                opFwd = TransformPathFlattenAlgebra.make(this.subject, pFwd, this.object);
            }
            if (!backwards.isEmpty()) {
                P_NegPropSet pBwd = new P_NegPropSet();
                for (P_Path0 p : backwards) {
                    pBwd.add(p);
                }
                opBwd = TransformPathFlattenAlgebra.make(this.subject, pBwd, this.object);
            }
            if (opFwd == null && opBwd == null) {
                this.result = TransformPathFlattenAlgebra.make(this.subject, pathNotOneOf, this.object);
                return;
            }
            this.result = TransformPathFlattenAlgebra.union(opFwd, opBwd);
        }

        @Override
        public void visit(P_Inverse inversePath) {
            PathTransform pt = new PathTransform(this.object, this.subject);
            inversePath.getSubPath().visit(pt);
            this.result = pt.getResult();
            if (this.result == null) {
                this.result = TransformPathFlattenAlgebra.make(this.object, inversePath.getSubPath(), this.subject);
            }
        }

        @Override
        public void visit(P_Mod pathMod) {
            if (pathMod.isFixedLength()) {
                if (pathMod.getFixedLength() > 0L) {
                    Op op;
                    Path p = PathFactory.pathFixedLength(pathMod.getSubPath(), pathMod.getFixedLength());
                    this.result = op = TransformPathFlattenAlgebra.transformPath(null, this.subject, p, this.object);
                } else {
                    this.result = null;
                }
                return;
            }
            if (pathMod.getMin() < 0L || pathMod.getMax() < 0L) {
                if (pathMod.getMin() > 0L) {
                    Var v = varAlloc.allocVar();
                    if (!this.subject.isVariable() || this.object.isVariable()) {
                        Path p1 = PathFactory.pathFixedLength(pathMod.getSubPath(), pathMod.getMin());
                        Path p2 = PathFactory.pathZeroOrMoreN(pathMod.getSubPath());
                        Op op1 = TransformPathFlattenAlgebra.transformPath(null, this.subject, p1, v);
                        Op op2 = TransformPathFlattenAlgebra.transformPath(null, v, p2, this.object);
                        this.result = OpSequence.create(op1, op2);
                    } else {
                        Path p1 = PathFactory.pathZeroOrMoreN(pathMod.getSubPath());
                        Path p2 = PathFactory.pathFixedLength(pathMod.getSubPath(), pathMod.getMin());
                        Op op1 = TransformPathFlattenAlgebra.transformPath(null, this.subject, p1, v);
                        Op op2 = TransformPathFlattenAlgebra.transformPath(null, v, p2, this.object);
                        this.result = OpSequence.create(op2, op1);
                    }
                    return;
                }
                this.result = null;
                return;
            }
            if (pathMod.getMin() > pathMod.getMax()) {
                throw new ARQException("Bad path: " + pathMod);
            }
            Op op = null;
            for (long i = pathMod.getMin(); i <= pathMod.getMax(); ++i) {
                Path p = PathFactory.pathFixedLength(pathMod.getSubPath(), i);
                Op sub = TransformPathFlattenAlgebra.transformPath(null, this.subject, p, this.object);
                op = TransformPathFlattenAlgebra.union(op, sub);
            }
            this.result = op;
        }

        @Override
        public void visit(P_FixedLength pFixedLength) {
            Op op = null;
            Node v1 = null;
            int i = 0;
            while ((long)i < pFixedLength.getCount()) {
                Var v2 = varAlloc.allocVar();
                Node s2 = v1 == null ? this.subject : v1;
                Node o = (long)i == pFixedLength.getCount() - 1L ? this.object : v2;
                Op op1 = TransformPathFlattenAlgebra.transformPath(null, s2, pFixedLength.getSubPath(), o);
                op = TransformPathFlattenAlgebra.join(op, op1);
                v1 = v2;
                ++i;
            }
            this.result = op;
        }

        @Override
        public void visit(P_Alt pathAlt) {
            Op op1 = TransformPathFlattenAlgebra.transformPath(null, this.subject, pathAlt.getLeft(), this.object);
            Op op2 = TransformPathFlattenAlgebra.transformPath(null, this.subject, pathAlt.getRight(), this.object);
            this.result = TransformPathFlattenAlgebra.union(op1, op2);
        }

        @Override
        public void visit(P_Seq pathSeq) {
            Var v = varAlloc.allocVar();
            Op op1 = TransformPathFlattenAlgebra.transformPath(null, this.subject, pathSeq.getLeft(), v);
            Op op2 = TransformPathFlattenAlgebra.transformPath(null, v, pathSeq.getRight(), this.object);
            this.result = !this.subject.isVariable() || this.object.isVariable() ? TransformPathFlattenAlgebra.join(op1, op2) : TransformPathFlattenAlgebra.join(op2, op1);
        }
    }
}

