/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.eval.ShapeEval;
import org.apache.jena.shex.expressions.TripleExprEachOf;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.sys.ValidationContext;

class ShapeEvalEachOf {
    ShapeEvalEachOf() {
    }

    static boolean matchesEachOf(ValidationContext vCxt, Set<Triple> matchables, Node node, TripleExprEachOf eachOf, Set<Node> extras) {
        ListValuedMap<Node, Integer> predicateToTripleExprs = MultiMapUtils.newListValuedHashMap();
        List<TripleExpression> tripleExprs = eachOf.expressions();
        int N2 = tripleExprs.size();
        for (int i = 0; i < N2; ++i) {
            TripleExpression tExpr = tripleExprs.get(i);
            Set<Node> pred = ShapeEval.findPredicates(vCxt, tExpr);
            for (Node p : pred) {
                predicateToTripleExprs.put(p, i);
            }
        }
        List<List<Set<Triple>>> partitions = ShapeEvalEachOf.partition(matchables, tripleExprs, predicateToTripleExprs);
        if (ShapeEval.DEBUG_eachOf) {
            System.out.println("EachOf: " + eachOf);
            if (partitions == null) {
                System.out.println("<null>");
            } else if (partitions.isEmpty()) {
                System.out.println("<empty>");
            }
        }
        if (partitions == null) {
            return false;
        }
        for (List<Set<Triple>> partition : partitions) {
            boolean success = true;
            for (int i = 0; i < N2; ++i) {
                Set<Triple> triples = partition.get(i);
                TripleExpression tripleExpr = tripleExprs.get(i);
                if (ShapeEval.DEBUG_eachOf) {
                    System.out.println("Partition: " + partition);
                }
                boolean b = ShapeEval.matches(vCxt, triples, node, tripleExpr, extras);
                if (ShapeEval.DEBUG_eachOf) {
                    System.out.println("    " + b);
                }
                if (b) continue;
                success = false;
                break;
            }
            if (!success || !eachOf.testSemanticActions(vCxt, matchables)) continue;
            return true;
        }
        return false;
    }

    private static List<List<Set<Triple>>> partition(Collection<Triple> triples, List<TripleExpression> tripleExprs, ListValuedMap<Node, Integer> predicateToTripleExprs) {
        for (Triple t2 : triples) {
            if (predicateToTripleExprs.containsKey(t2.getPredicate())) continue;
            return null;
        }
        List<Set<Triple>> emptyPartial = ShapeEvalEachOf.emptyPartition(tripleExprs);
        ArrayList<List<Set<Triple>>> partials = new ArrayList<List<Set<Triple>>>();
        partials.add(emptyPartial);
        for (Triple t3 : triples) {
            ArrayList<List<Set<Triple>>> partials2 = new ArrayList<List<Set<Triple>>>();
            for (List list : partials) {
                List<List<Set<Triple>>> p = ShapeEvalEachOf.partition(t3, list, tripleExprs, predicateToTripleExprs);
                partials2.addAll(p);
            }
            partials = partials2;
        }
        return partials;
    }

    private static List<List<Set<Triple>>> partition(Triple t2, List<Set<Triple>> partial, List<TripleExpression> tripleExprs, ListValuedMap<Node, Integer> predicateToTripleExprs) {
        Node p = t2.getPredicate();
        Collection places = predicateToTripleExprs.get((Object)p);
        if (places == null || places.isEmpty()) {
            throw new InternalErrorException();
        }
        ArrayList<List<Set<Triple>>> result = new ArrayList<List<Set<Triple>>>();
        Iterator iterator = places.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ArrayList<Set<Triple>> partial2 = new ArrayList<Set<Triple>>(partial);
            Set x = (Set)partial2.get(i);
            HashSet<Triple> x2 = new HashSet<Triple>(x);
            x2.add(t2);
            partial2.set(i, x2);
            result.add(partial2);
        }
        return result;
    }

    private static List<Set<Triple>> emptyPartition(List<TripleExpression> tripleExprs) {
        int N2 = tripleExprs.size();
        ArrayList<Set<Triple>> partition = new ArrayList<Set<Triple>>(N2);
        for (int i = 0; i < N2; ++i) {
            partition.add(new HashSet());
        }
        return partition;
    }
}

