/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.SparqlConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnSinglePathNodeEvent;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.ModelUtils;

class SparqlValidation {
    private static final boolean USE_QueryTransformOps = false;
    private static Pattern pattern = Pattern.compile("(\\{[\\$\\?][^{}]+\\})");

    SparqlValidation() {
    }

    public static void validate(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Node valueNode, Query query2, MultiValuedMap<Parameter, Node> parameterMap, String violationTemplate, Constraint reportConstraint) {
        if (parameterMap != null && parameterMap.keySet().size() == 1 && parameterMap.size() > 1) {
            for (Map.Entry<Parameter, Node> e2 : parameterMap.entries()) {
                Map<Parameter, Node> pmap = Collections.singletonMap(e2.getKey(), e2.getValue());
                boolean b = SparqlValidation.validateMap(vCxt, data, shape, focusNode, path, valueNode, query2, pmap, violationTemplate, reportConstraint);
                if (b) continue;
                return;
            }
            return;
        }
        Map<Parameter, Node> pmap = SparqlValidation.flatten(parameterMap);
        SparqlValidation.validateMap(vCxt, data, shape, focusNode, path, valueNode, query2, pmap, violationTemplate, reportConstraint);
    }

    private static Map<Parameter, Node> flatten(MultiValuedMap<Parameter, Node> parameterMap) {
        if (parameterMap == null) {
            return null;
        }
        HashMap<Parameter, Node> pmap = new HashMap<Parameter, Node>(parameterMap.size());
        parameterMap.mapIterator().forEachRemaining(k -> parameterMap.get((Parameter)k).forEach(v -> pmap.put((Parameter)k, (Node)v)));
        return pmap;
    }

    private static boolean validateMap(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Node valueNode, Query _query, Map<Parameter, Node> parameterMap, String violationTemplate, Constraint reportConstraint) {
        Model model = ModelFactory.createModelForGraph(data);
        Query query2 = _query;
        if (path != null && !(path instanceof P_Link)) {
            query2 = QueryTransformOps.transform(query2, new ElementTransformPath(SparqlConstraint.varPath, path));
        }
        QuerySolutionMap qsm = SparqlValidation.parameterMapToPreBinding(parameterMap, focusNode, path, model);
        if (query2.isAskType()) {
            qsm.add("value", ModelUtils.convertGraphNodeToRDFNode(valueNode, model));
        }
        Resource shapesGraphResource = model.createResource("foo");
        qsm.add("currentShape", ModelUtils.convertGraphNodeToRDFNode(shape.getShapeNode(), model));
        qsm.add("shapesGraph", shapesGraphResource);
        DatasetGraph dsg = DatasetGraphFactory.createGeneral(model.getGraph());
        dsg.addGraph(shapesGraphResource.asNode(), shape.getShapeGraph());
        Dataset ds = DatasetFactory.wrap(dsg);
        QueryExecution qExec = QueryExecution.create().query(query2).dataset(ds).initialBinding(qsm).build();
        if (qExec.getQuery().isAskType()) {
            boolean b = qExec.execAsk();
            if (!b) {
                String msg = violationTemplate == null ? "SPARQL ASK constraint for " + ShLib.displayStr(valueNode) + " returns false" : SparqlValidation.substitute(violationTemplate, parameterMap, focusNode, path, valueNode);
                vCxt.reportEntry(msg, shape, focusNode, path, valueNode, reportConstraint);
            }
            vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnSinglePathNodeEvent(vCxt, shape, focusNode, reportConstraint, path, valueNode, b));
            return b;
        }
        ResultSet rs = qExec.execSelect();
        if (!rs.hasNext()) {
            vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnSinglePathNodeEvent(vCxt, shape, focusNode, reportConstraint, path, valueNode, true));
            return true;
        }
        while (rs.hasNext()) {
            Node qPath;
            Binding row = rs.nextBinding();
            Node value = row.get(SparqlConstraint.varValue);
            if (value == null) {
                value = valueNode;
            }
            Object msg = violationTemplate == null ? (value != null ? "SPARQL SELECT constraint for " + ShLib.displayStr(valueNode) + " returns " + ShLib.displayStr(value) : "SPARQL SELECT constraint for " + ShLib.displayStr(valueNode) + " returns row " + row) : SparqlValidation.substitute(violationTemplate, row);
            Path rPath = path;
            if (rPath == null && (qPath = row.get(SparqlConstraint.varPath)) != null) {
                rPath = PathFactory.pathLink(qPath);
            }
            Path finalRPath = rPath;
            Node finalValue = value;
            vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnSinglePathNodeEvent(vCxt, shape, focusNode, reportConstraint, finalRPath, finalValue, false));
            vCxt.reportEntry((String)msg, shape, focusNode, rPath, value, reportConstraint);
        }
        return false;
    }

    private static String substitute(String violationTemplate, Binding row) {
        String x = violationTemplate;
        Iterator<Var> iter = row.vars();
        while (iter.hasNext()) {
            Var var = iter.next();
            x = SparqlValidation.substit(x, var.getVarName(), row.get(var));
        }
        return x;
    }

    private static String substitute(String violationTemplate, Map<Parameter, Node> parameterMap, Node focusNode, Path path, Node valueNode) {
        String x = violationTemplate;
        for (Map.Entry<Parameter, Node> e2 : parameterMap.entrySet()) {
            x = SparqlValidation.substit(x, e2.getKey().getSparqlName(), e2.getValue());
        }
        return x;
    }

    private static String substit(String x, String name, Node value) {
        try {
            String vn = "\\{[?$]" + Matcher.quoteReplacement(name) + "\\}";
            String val = SparqlValidation.strQuoted(value);
            return x.replaceAll(vn, val);
        }
        catch (RuntimeException ex) {
            Log.warn(SparqlValidation.class, "Failed to substitute into string for name=" + name + " value=" + value);
            return x;
        }
    }

    private static String strQuoted(Node node) {
        String x = node.isLiteral() ? node.getLiteralLexicalForm() : ShLib.displayStr(node);
        x = Matcher.quoteReplacement(x);
        return x;
    }

    private static Map<Var, Node> parameterMapToSyntaxSubstitutions(Map<Parameter, Node> parameterMap, Node thisNode, Path path) {
        Map<Var, Node> substitions = SparqlValidation.parametersToMap(parameterMap, thisNode);
        if (path != null) {
            SparqlValidation.addSubstition(substitions, "PATH", ShaclPaths.pathNode(path));
        }
        return substitions;
    }

    private static Map<Var, Node> parametersToMap(Map<Parameter, Node> parameterMap, Node thisNode) {
        HashMap<Var, Node> substitions = new HashMap<Var, Node>();
        if (parameterMap != null) {
            parameterMap.forEach((p, n) -> SparqlValidation.addSubstition(substitions, p.getSparqlName(), n));
        }
        SparqlValidation.addSubstition(substitions, "this", thisNode);
        return substitions;
    }

    private static QuerySolutionMap parameterMapToPreBinding(Map<Parameter, Node> parameterMap, Node thisNode, Path path, Model model) {
        Node pn;
        QuerySolutionMap qsm = new QuerySolutionMap();
        if (parameterMap != null) {
            parameterMap.forEach((p, n) -> qsm.add(p.getSparqlName(), ModelUtils.convertGraphNodeToRDFNode(n, model)));
        }
        qsm.add("this", ModelUtils.convertGraphNodeToRDFNode(thisNode, model));
        if (path != null && (pn = ShaclPaths.pathNode(path)) != null) {
            RDFNode z = ModelUtils.convertGraphNodeToRDFNode(pn, model);
            qsm.add("PATH", z);
        }
        return qsm;
    }

    private static void addSubstition(Map<Var, Node> substitions, String sparqlName, Node n) {
        substitions.put(Var.alloc(sparqlName), n);
    }

    private static String messageTemplate(String message, Map<Parameter, Node> parameterMap, Node thisNode, Path path) {
        Map<Var, Node> substitions = SparqlValidation.parametersToMap(parameterMap, thisNode);
        Pattern pattern = Pattern.compile("{[$?][^{}]+}");
        if (path != null) {
            substitions.put(Var.alloc("PATH"), NodeFactory.createLiteralString(ShaclPaths.pathToString(path)));
        }
        return SparqlValidation.subsitute(message, substitions);
    }

    private static String subsitute(String string, Map<Var, Node> substitions) {
        StringBuilder sb = new StringBuilder();
        Matcher m4 = pattern.matcher(string);
        int prev = 0;
        while (m4.find()) {
            int i1 = m4.start();
            int i2 = m4.end();
            String var = m4.group();
            String varName = var.substring(2, i2 - i1 - 1);
            sb.append(string.substring(prev, i1));
            Var v = Var.alloc(varName);
            Node n = substitions.get(v);
            if (n == null) {
                sb.append(var);
            } else {
                String z = NodeFmtLib.displayStr(n);
                sb.append(z);
            }
            prev = i2;
        }
        sb.append(string.substring(prev));
        return sb.toString();
    }

    private static class ElementTransformPath
    extends ElementTransformCopyBase {
        private final Var var;
        private final Path path;

        ElementTransformPath(Var varPath, Path path) {
            this.var = varPath;
            this.path = path;
        }

        @Override
        public Element transform(ElementPathBlock el) {
            ElementPathBlock el2 = new ElementPathBlock();
            boolean changed = false;
            PathBlock pathBlock = el.getPattern();
            List<TriplePath> x = pathBlock.getList();
            for (TriplePath tp : x) {
                if (!tp.isTriple()) {
                    el2.addTriple(tp);
                    continue;
                }
                Triple t2 = tp.asTriple();
                if (!this.var.equals(t2.getPredicate())) {
                    el2.addTriple(tp);
                    continue;
                }
                TriplePath tp2 = new TriplePath(t2.getSubject(), this.path, t2.getObject());
                el2.addTriple(tp2);
                changed = true;
            }
            return changed ? el2 : el;
        }
    }
}

