/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.reader;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.extra.LangParserBase;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;

public class ShaclCompactParser
extends LangParserBase {
    private String baseURI = null;
    private Deque<Node> currentNodeShape = new ArrayDeque<Node>();
    private Deque<Node> currentPropertyShape = new ArrayDeque<Node>();
    private Deque<List<Node>> nodeShapeCollectors = new ArrayDeque<List<Node>>();
    private Deque<List<Node>> propertyShapeCollectors = new ArrayDeque<List<Node>>();
    private Deque<List<Triple>> currentConstraintTriples = new ArrayDeque<List<Triple>>();
    private String baseSeen = null;
    private Map<String, String> prefixesSeen = new HashMap<String, String>();
    private List<String> imports = new ArrayList<String>();

    protected ShaclCompactParser() {
    }

    private void setBaseURI(String baseURI) {
        super.setBase(baseURI, -1, -1);
        this.baseURI = baseURI;
    }

    public void start() {
        if (this.stream == null) {
            throw new ShaclException("Output stream not set");
        }
    }

    public void finish() {
        String base = this.baseURI;
        if (base == null) {
            base = "urn:x-base:default";
        }
        Node s2 = this.iri(base);
        ShaclCompactParser.triple(this.stream, s2, this.nRDFtype, OWL.Ontology.asNode());
        this.imports.forEach(iri2 -> ShaclCompactParser.triple(this.stream, s2, OWL.imports.asNode(), this.iri((String)iri2)));
        if (!this.currentNodeShape.isEmpty()) {
            throw new InternalErrorException("Internal error: Node shape stack is not empty at end of parsing");
        }
        if (!this.currentPropertyShape.isEmpty()) {
            throw new InternalErrorException("Internal error: Property shape stack is not empty at end of parsing");
        }
    }

    protected void startNodeShape() {
    }

    protected void beginNodeShape(Node node) {
        this.currentNodeShape.push(node);
    }

    protected void finishNodeShape() {
        this.currentNodeShape.pop();
    }

    private Node currentNodeShape() {
        if (this.currentNodeShape.isEmpty()) {
            throw new InternalErrorException("Internal error: no current node shape");
        }
        return this.currentNodeShape.peek();
    }

    protected void startShapeClass() {
        this.startNodeShape();
    }

    protected void beginShapeClass(Node node) {
        this.beginNodeShape(node);
    }

    protected void finishShapeClass() {
        this.finishNodeShape();
    }

    protected void startPropertyShape() {
    }

    protected void beginPropertyShape(Node node) {
        this.currentPropertyShape.push(node);
    }

    protected void finishPropertyShape() {
        this.currentPropertyShape.pop();
    }

    private Node currentPropertyShape() {
        if (this.currentPropertyShape.isEmpty()) {
            throw new InternalErrorException("Internal error: no current property shape");
        }
        return this.currentPropertyShape.peek();
    }

    protected void startNodeShapeBody() {
    }

    protected void finishNodeShapeBody() {
    }

    protected void beginTripleAcc(List<Triple> acc) {
        this.currentConstraintTriples.push(acc);
    }

    protected void finishTripleAcc() {
        this.currentConstraintTriples.pop();
    }

    private List<Triple> currentTripleAcc() {
        if (this.currentConstraintTriples.isEmpty()) {
            throw new InternalErrorException("Internal error: no current tripel accumulator");
        }
        return this.currentConstraintTriples.peek();
    }

    protected void startConstraint() {
        ArrayList<Triple> acc = new ArrayList<Triple>();
        this.beginTripleAcc(acc);
    }

    protected void finishConstraint() {
        List<Triple> acc = this.currentTripleAcc();
        acc.forEach(this.stream::triple);
        this.finishTripleAcc();
    }

    protected void rBase(String baseURI) {
        this.setBaseURI(baseURI);
        this.stream.base(baseURI);
        this.baseSeen = baseURI;
    }

    protected void rPrefix(String prefix, String iriStr) {
        super.setPrefix(prefix, iriStr, -1, -1);
        this.stream.prefix(prefix, iriStr);
        this.prefixesSeen.put(prefix, iriStr);
    }

    protected void rImports(String iri2) {
        this.imports.add(iri2);
    }

    protected void rNodeShape(String iri2) {
        Node shape = this.iri(iri2);
        ShaclCompactParser.triple(this.stream, shape, this.nRDFtype, SHACL.NodeShape);
        this.beginNodeShape(shape);
    }

    protected void rShapeClass(String iri2) {
        Node s2 = this.iri(iri2);
        this.beginShapeClass(s2);
        ShaclCompactParser.triple(this.stream, s2, this.nRDFtype, SHACL.NodeShape);
        ShaclCompactParser.triple(this.stream, s2, this.nRDFtype, RDFS.Nodes.Class);
    }

    protected void rTargetClass(String iri2) {
        Node s2 = this.currentNodeShape();
        Node n = this.iri(iri2);
        ShaclCompactParser.triple(this.stream, s2, SHACL.targetClass, n);
    }

    protected void startNodeOr() {
        this.nodeShapeCollectors.add(new ArrayList());
    }

    protected void rNodeOr_pre() {
        Node blank = this.newBlankNode("nodeOr-elt");
        this.beginNodeShape(blank);
    }

    protected void rNodeOr_post() {
        Node n = this.currentNodeShape();
        this.nodeShapeCollectors.peek().add(n);
        this.finishNodeShape();
    }

    protected void finishNodeOr() {
        List<Node> elts = this.nodeShapeCollectors.pop();
        if (elts.isEmpty()) {
            throw new InternalErrorException("No elements in nodeOr");
        }
        if (elts.size() == 1) {
            this.rewriteSubj(this.currentTripleAcc(), elts.get(0), this.currentNodeShape());
            return;
        }
        Node list = this.listToTriples(elts);
        this.triple(this.currentTripleAcc(), this.currentNodeShape(), SHACL.or, list);
    }

    protected void startNodeNot() {
    }

    protected void beginNodeNot(boolean negation) {
        if (!negation) {
            return;
        }
        Node blank = this.newBlankNode("nodeNot");
        this.beginNodeShape(blank);
    }

    protected void finishNodeNot(boolean negation) {
        if (!negation) {
            return;
        }
        Node n = this.currentNodeShape();
        this.finishNodeShape();
        Node nodeShape = this.currentNodeShape();
        this.triple(this.currentTripleAcc(), nodeShape, SHACL.not, n);
    }

    protected void rNodeValue(String s2, Node n) {
        Node p = NodeFactory.createURI(SHACL.getURI() + s2);
        this.triple(this.currentTripleAcc(), this.currentNodeShape(), p, n);
    }

    protected void rNodeValue(String s2, List<Node> x) {
        Node n = this.nodeArrayToTriples(x);
        Node p = NodeFactory.createURI(SHACL.getURI() + s2);
        this.triple(this.currentTripleAcc(), this.currentNodeShape(), p, n);
    }

    protected void rPropertyShape(Path parsedPath) {
        Node path = this.pathToNode(parsedPath);
        Node b = this.newBlankNode("propertyShape");
        this.beginPropertyShape(b);
        this.triple(this.currentTripleAcc(), this.currentNodeShape(), SHACL.property, this.currentPropertyShape());
        if (path == null) {
            throw new ShaclException("Internal error: no path");
        }
        this.triple(this.currentTripleAcc(), this.currentPropertyShape(), SHACL.path, path);
    }

    protected void rPropertyCount(String minStr, String maxStr) {
        int min2 = this.integer(minStr, 0);
        int max2 = this.integer(maxStr, -1);
        if (min2 > 0) {
            this.triple(this.currentTripleAcc(), this.currentPropertyShape(), SHACL.minCount, NodeFactory.createLiteral(minStr, XSDDatatype.XSDinteger));
        }
        if (max2 > 0) {
            this.triple(this.currentTripleAcc(), this.currentPropertyShape(), SHACL.maxCount, NodeFactory.createLiteral(maxStr, XSDDatatype.XSDinteger));
        }
    }

    protected void startPropertyOr() {
        this.propertyShapeCollectors.add(new ArrayList());
    }

    protected void rPropertyOr_pre() {
        Node blank = this.newBlankNode("propertyOr-elt");
        this.beginPropertyShape(blank);
    }

    protected void rPropertyOr_post() {
        Node n = this.currentPropertyShape();
        this.propertyShapeCollectors.peek().add(n);
        this.finishPropertyShape();
    }

    protected void finishPropertyOr() {
        List<Node> elts = this.propertyShapeCollectors.pop();
        if (elts.isEmpty()) {
            throw new InternalErrorException("No elements in propertyOr");
        }
        if (elts.size() == 1) {
            this.rewriteSubj(this.currentTripleAcc(), elts.get(0), this.currentPropertyShape());
            return;
        }
        Node list = this.listToTriples(elts);
        this.triple(this.currentTripleAcc(), this.currentPropertyShape(), SHACL.or, list);
    }

    protected void startPropertyNot() {
    }

    protected void beginPropertyNot(boolean negation) {
        if (!negation) {
            return;
        }
        Node blank = this.newBlankNode("propertyNot");
        this.beginPropertyShape(blank);
    }

    protected void finishPropertyNot(boolean negation) {
        if (!negation) {
            return;
        }
        Node n = this.currentPropertyShape();
        this.finishPropertyShape();
        Node propertyShape = this.currentPropertyShape();
        this.triple(this.currentTripleAcc(), propertyShape, SHACL.not, n);
    }

    protected void startNestedPropertyAtom() {
        Node b = this.newBlankNode("nested-shape");
        this.startNodeShape();
        this.triple(this.currentTripleAcc(), this.currentPropertyShape(), SHACL.node, b);
        this.beginNodeShape(b);
    }

    protected void finishNestedPropertyAtom() {
        this.finishNodeShape();
    }

    protected void rPropertyType(String iri2) {
        Node p = ShLib.isDatatype(iri2) ? SHACL.datatype : SHACL.class_;
        this.triple(this.currentTripleAcc(), this.currentPropertyShape(), p, this.iri(iri2));
    }

    protected void rNodeKind(String nodeKindName) {
        Node nodeKind = this.iri(SHACL.getURI() + nodeKindName);
        this.triple(this.currentTripleAcc(), this.currentPropertyShape(), SHACL.nodeKind, nodeKind);
    }

    private Node pathToNode(Path parsedPath) {
        return ShaclPaths.pathToRDF(parsedPath, this.stream);
    }

    protected void rShapeRef(boolean inPropertyShape, String iriStr) {
        Node x = this.iri(iriStr);
        if (inPropertyShape) {
            this.triple(this.currentTripleAcc(), this.currentPropertyShape(), SHACL.node, x);
        } else {
            this.triple(this.currentTripleAcc(), this.currentNodeShape(), SHACL.node, x);
        }
    }

    protected void rParamValue(String s2, Node n) {
        Node p = NodeFactory.createURI(SHACL.getURI() + s2);
        this.triple(this.currentTripleAcc(), this.currentPropertyShape(), p, n);
    }

    protected void rParamValue(String s2, List<Node> x) {
        Node n = this.nodeArrayToTriples(x);
        Node p = NodeFactory.createURI(SHACL.getURI() + s2);
        this.triple(this.currentTripleAcc(), this.currentPropertyShape(), p, n);
    }

    private Node nodeArrayToTriples(List<Node> x) {
        Node list = this.nRDFnil;
        ListIterator<Node> iter = x.listIterator(x.size());
        while (iter.hasPrevious()) {
            Node elt = iter.previous();
            Node z = this.newBlankNode("array");
            this.triple(this.currentTripleAcc(), z, this.nRDFfirst, elt);
            this.triple(this.currentTripleAcc(), z, this.nRDFrest, list);
            list = z;
        }
        return list;
    }

    private Node iriOrLiteral(Node x) {
        if (x.isURI()) {
            return x;
        }
        String s2 = x.getLiteralLexicalForm();
        PrefixMap pmap = this.profile.getPrefixMap();
        Node n = TokenizerText.create().fromString(s2).build().next().asNode(pmap);
        return n;
    }

    private int integer(String str2, int i) {
        if (str2 == null || str2.equals("*")) {
            return i;
        }
        try {
            return Integer.parseInt(str2);
        }
        catch (NumberFormatException ex) {
            System.err.println("Number format exception");
            return i;
        }
    }

    private Node listToTriples(List<Node> x) {
        Node list = this.nRDFnil;
        ListIterator<Node> iter = x.listIterator(x.size());
        while (iter.hasPrevious()) {
            Node elt = iter.previous();
            Node z = this.newBlankNode("list");
            this.triple(this.currentTripleAcc(), z, this.nRDFfirst, elt);
            this.triple(this.currentTripleAcc(), z, this.nRDFrest, list);
            list = z;
        }
        return list;
    }

    private Node iri(String iriStr) {
        return NodeFactory.createURI(iriStr);
    }

    private Node newBlankNode(String label) {
        return NodeFactory.createBlankNode();
    }

    private void rewriteSubj(List<Triple> accumulator, Node node1, Node node2) {
        for (int i = 0; i < accumulator.size(); ++i) {
            Triple t2 = accumulator.get(i);
            if (!t2.getSubject().equals(node1)) continue;
            Triple t22 = Triple.create(node2, t2.getPredicate(), t2.getObject());
            accumulator.set(i, t22);
        }
    }

    private void triple(Collection<Triple> acc, Node s2, Node p, Node o) {
        Triple triple = Triple.create(s2, p, o);
        acc.add(triple);
    }

    private static void triple(StreamRDF out, Node s2, Node p, Node o) {
        Triple triple = Triple.create(s2, p, o);
        out.triple(triple);
    }

    private /* synthetic */ void lambda$finish$1(Node s2, String iri2) {
        ShaclCompactParser.triple(this.stream, s2, OWL.imports.asNode(), this.iri(iri2));
    }
}

