/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput1.impl;

import java.util.regex.Pattern;
import org.apache.jena.irix.IRIx;
import org.apache.jena.rdfxml.xmlinput1.ARPErrorNumbers;
import org.apache.jena.rdfxml.xmlinput1.impl.Taint;
import org.apache.jena.rdfxml.xmlinput1.impl.TaintImpl;
import org.apache.jena.rdfxml.xmlinput1.impl.XMLBaselessContext;
import org.apache.jena.rdfxml.xmlinput1.impl.XMLContext;
import org.apache.jena.rdfxml.xmlinput1.impl.XMLHandler;
import org.apache.jena.shared.JenaException;
import org.xml.sax.SAXParseException;

public abstract class AbsXMLContext
implements ARPErrorNumbers {
    protected final String lang;
    protected final Taint langTaint;
    final Taint baseTaint;
    protected final IRIx uri;
    protected final AbsXMLContext document;
    private static Pattern langPattern = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    protected AbsXMLContext(boolean useDoc, AbsXMLContext document, IRIx uri, Taint baseT, String lang, Taint langT) {
        this.lang = lang;
        this.langTaint = langT;
        this.baseTaint = baseT;
        this.uri = uri;
        this.document = useDoc ? (document == null ? this : document) : null;
    }

    protected static Taint initTaint(XMLHandler h2, IRIx base) throws SAXParseException {
        TaintImpl rslt = new TaintImpl();
        AbsXMLContext.checkURI(h2, rslt, base);
        return rslt;
    }

    public AbsXMLContext withBase(XMLHandler forErrors, String baseURI) throws SAXParseException {
        TaintImpl taintB = new TaintImpl();
        IRIx newBase = this.resolveAsURI(forErrors, taintB, baseURI, false);
        if (newBase.isRelative()) {
            return new XMLBaselessContext(forErrors, 215, newBase);
        }
        if (newBase.hasViolations()) {
            return new XMLBaselessContext(forErrors, 214, newBase);
        }
        return new XMLContext(this.keepDocument(forErrors), this.document, newBase, taintB, this.lang, this.langTaint);
    }

    abstract boolean keepDocument(XMLHandler var1);

    protected AbsXMLContext withLang(XMLHandler forErrors, String l) throws SAXParseException {
        TaintImpl taint = new TaintImpl();
        this.checkXMLLang(forErrors, taint, l);
        return this.clone(this.uri, this.baseTaint, l, taint);
    }

    abstract AbsXMLContext clone(IRIx var1, Taint var2, String var3, Taint var4);

    public String getLang(Taint taint) {
        if (this.langTaint.isTainted()) {
            taint.taint();
        }
        return this.lang;
    }

    final IRIx resolveAsURI(XMLHandler forErrors, Taint taintMe, String relUri) throws SAXParseException {
        return this.resolveAsURI(forErrors, taintMe, relUri, true);
    }

    final IRIx resolveAsURI(XMLHandler forErrors, Taint taintMe, String relUri, boolean checkBaseUse) throws SAXParseException {
        IRIx rslt = this.uri.resolve(relUri);
        if (checkBaseUse) {
            this.checkBaseUse(forErrors, taintMe, relUri, rslt);
        }
        AbsXMLContext.checkURI(forErrors, taintMe, rslt);
        return rslt;
    }

    abstract void checkBaseUse(XMLHandler var1, Taint var2, String var3, IRIx var4) throws SAXParseException;

    protected static void checkURI(XMLHandler forErrors, Taint taintMe, IRIx rslt) throws SAXParseException {
        try {
            if (rslt.isRelative() && !forErrors.allowRelativeURIs()) {
                forErrors.warning(taintMe, 136, "Relative URIs are not permitted in RDF: specifically <" + rslt.toString() + ">");
            }
        }
        catch (SAXParseException ex) {
            throw new JenaException("SAXParseException: " + ex.getMessage());
        }
        rslt.handleViolations((isError, msg) -> {
            try {
                forErrors.warning(taintMe, 107, "Bad URI: " + msg);
            }
            catch (SAXParseException ex) {
                throw new JenaException("SAXParseException: " + ex.getMessage());
            }
        });
    }

    public String resolve(XMLHandler forErrors, Taint taintMe, String u) throws SAXParseException {
        return this.resolveAsURI(forErrors, taintMe, u, true).toString();
    }

    private void checkXMLLang(XMLHandler arp, Taint taintMe, String newLang) throws SAXParseException {
        if (newLang.equals("")) {
            return;
        }
        if (newLang.equalsIgnoreCase("und")) {
            arp.warning(taintMe, 116, "Bad language tag: " + newLang + " (not allowed)");
        }
        if (!langPattern.matcher(newLang).matches()) {
            arp.warning(taintMe, 116, "Bad language tag: " + newLang);
        }
    }
}

