/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.system;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;

public abstract class AbstractDatasetGraphAddDelete
extends DatasetGraphWrapper {
    private static final int DeleteBufferSize = 10000;

    public AbstractDatasetGraphAddDelete(DatasetGraph dsg) {
        super(dsg);
    }

    protected abstract void actionAdd(Node var1, Node var2, Node var3, Node var4);

    protected abstract void actionDelete(Node var1, Node var2, Node var3, Node var4);

    @Override
    public void add(Quad quad) {
        this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        this.actionAdd(g2, s2, p, o);
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        this.actionDelete(g2, s2, p, o);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        graph.find(null, null, null).forEachRemaining(t2 -> this.add(graphName, t2.getSubject(), t2.getPredicate(), t2.getObject()));
    }

    @Override
    public void removeGraph(Node graphName) {
        this.deleteAny(graphName, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public void clear() {
        this.deleteAny(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph(this);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph(this.get(), graphNode);
    }

    @Override
    public void deleteAny(Node g2, Node s2, Node p, Node o) {
        int len;
        Quad[] buffer = new Quad[10000];
        do {
            Iterator<Quad> iter = this.find(g2, s2, p, o);
            for (len = 0; len < 10000 && iter.hasNext(); ++len) {
                buffer[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                this.delete(buffer[i]);
                buffer[i] = null;
            }
        } while (len >= 10000);
    }
}

