/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.binary;

import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfpatch.PatchException;
import org.apache.jena.rdfpatch.PatchHeader;
import org.apache.jena.rdfpatch.PatchProcessor;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.RDFPatch;
import org.apache.jena.rdfpatch.changes.RDFChangesCollector;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.wire.PatchTxn;
import org.apache.jena.riot.thrift.wire.Patch_Data_Add;
import org.apache.jena.riot.thrift.wire.Patch_Data_Del;
import org.apache.jena.riot.thrift.wire.Patch_Header;
import org.apache.jena.riot.thrift.wire.Patch_Prefix_Add;
import org.apache.jena.riot.thrift.wire.Patch_Prefix_Del;
import org.apache.jena.riot.thrift.wire.RDF_Literal;
import org.apache.jena.riot.thrift.wire.RDF_Patch_Row;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_Triple;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransportException;

public class RDFPatchReaderBinary
implements PatchProcessor {
    private final InputStream input;

    private RDFPatchReaderBinary(InputStream input) {
        this.input = input;
    }

    @Override
    public void apply(RDFChanges processor) {
        RDFPatchReaderBinary.read(this.input, processor);
    }

    public static PatchProcessor create(InputStream input) {
        return new RDFPatchReaderBinary(input);
    }

    public static RDFPatch read(InputStream input) {
        RDFChangesCollector changes = new RDFChangesCollector();
        RDFPatchReaderBinary.read(input, (RDFChanges)changes);
        return changes.getRDFPatch();
    }

    public static PatchHeader readHeader(InputStream input) {
        TProtocol protocol = TRDF.protocol(input);
        return RDFPatchReaderBinary.readHeader(protocol);
    }

    private static PatchHeader readHeader(TProtocol protocol) {
        RDF_Patch_Row row = new RDF_Patch_Row();
        LinkedHashMap<String, Node> header = new LinkedHashMap<String, Node>();
        while (true) {
            row.clear();
            try {
                row.read(protocol);
            }
            catch (TTransportException e2) {
                if (e2.getType() == 4) break;
                throw new PatchException("Thrift exception", e2);
            }
            catch (TException e3) {
                throw new PatchException("Thrift exception", e3);
            }
            if (!row.isSetHeader()) break;
            Patch_Header h2 = row.getHeader();
            Node n = RDFPatchReaderBinary.fromThrift(h2.getValue());
            header.put(h2.getName(), n);
        }
        return new PatchHeader(header);
    }

    public static void read(InputStream input, RDFChanges changes) {
        RDFPatchReaderBinary.read(TRDF.protocol(input), changes);
    }

    public static void read(TProtocol protocol, RDFChanges changes) {
        RDF_Patch_Row row = new RDF_Patch_Row();
        changes.start();
        while (true) {
            row.clear();
            try {
                row.read(protocol);
            }
            catch (TTransportException e2) {
                if (e2.getType() == 4) {
                    changes.finish();
                    return;
                }
                throw new PatchException("Thrift exception", e2);
            }
            catch (TException e3) {
                throw new PatchException("Thrift exception", e3);
            }
            RDFPatchReaderBinary.dispatch(row, changes);
        }
    }

    private static void dispatch(RDF_Patch_Row row, RDFChanges changes) {
        if (row.isSetHeader()) {
            Patch_Header h2 = row.getHeader();
            Node n = RDFPatchReaderBinary.fromThrift(h2.getValue());
            changes.header(h2.getName(), n);
            return;
        }
        if (row.isSetDataAdd()) {
            Patch_Data_Add add = row.getDataAdd();
            Node s2 = RDFPatchReaderBinary.fromThrift(add.getS());
            Node p = RDFPatchReaderBinary.fromThrift(add.getP());
            Node o = RDFPatchReaderBinary.fromThrift(add.getO());
            Node g2 = null;
            if (add.isSetG()) {
                g2 = RDFPatchReaderBinary.fromThrift(add.getG());
            }
            changes.add(g2, s2, p, o);
            return;
        }
        if (row.isSetDataDel()) {
            Patch_Data_Del del = row.getDataDel();
            Node s3 = RDFPatchReaderBinary.fromThrift(del.getS());
            Node p = RDFPatchReaderBinary.fromThrift(del.getP());
            Node o = RDFPatchReaderBinary.fromThrift(del.getO());
            Node g3 = null;
            if (del.isSetG()) {
                g3 = RDFPatchReaderBinary.fromThrift(del.getG());
            }
            changes.delete(g3, s3, p, o);
            return;
        }
        if (row.isSetPrefixAdd()) {
            Patch_Prefix_Add add = row.getPrefixAdd();
            Node gn = null;
            if (add.isSetGraphNode()) {
                gn = RDFPatchReaderBinary.fromThrift(add.getGraphNode());
            }
            changes.addPrefix(gn, add.getPrefix(), add.getIriStr());
            return;
        }
        if (row.isSetPrefixDel()) {
            Patch_Prefix_Del del = row.getPrefixDel();
            Node gn = null;
            if (del.isSetGraphNode()) {
                gn = RDFPatchReaderBinary.fromThrift(del.getGraphNode());
            }
            changes.deletePrefix(gn, del.getPrefix());
            return;
        }
        if (row.isSetTxn()) {
            PatchTxn txn = row.getTxn();
            switch (txn) {
                case TX: {
                    changes.txnBegin();
                    break;
                }
                case TC: {
                    changes.txnCommit();
                    break;
                }
                case TA: {
                    changes.txnAbort();
                    break;
                }
                case Segment: {
                    changes.segment();
                }
            }
            return;
        }
        throw new PatchException("Unrecogized :" + row);
    }

    public static Node fromThrift(RDF_Term term) {
        if (term.isSetIri()) {
            return NodeFactory.createURI(term.getIri().getIri());
        }
        if (term.isSetBnode()) {
            return NodeFactory.createBlankNode(term.getBnode().getLabel());
        }
        if (term.isSetLiteral()) {
            RDF_Literal lit = term.getLiteral();
            String lex = lit.getLex();
            String dtString = null;
            if (lit.isSetDatatype()) {
                dtString = lit.getDatatype();
            }
            RDFDatatype dt = NodeFactory.getType(dtString);
            String lang = lit.getLangtag();
            return NodeFactory.createLiteral(lex, lang, dt);
        }
        if (term.isSetTripleTerm()) {
            RDF_Triple rt = term.getTripleTerm();
            Node s2 = RDFPatchReaderBinary.fromThrift(rt.getS());
            Node p = RDFPatchReaderBinary.fromThrift(rt.getP());
            Node o = RDFPatchReaderBinary.fromThrift(rt.getO());
            Triple t2 = Triple.create(s2, p, o);
            return NodeFactory.createTripleNode(t2);
        }
        throw new PatchException("No conversion to a Node: " + term.toString());
    }
}

