/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.BunchMap;
import org.apache.jena.mem.FieldFilter;
import org.apache.jena.mem.HashCommon;
import org.apache.jena.mem.HashedBunchMap;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.NullIterator;

public abstract class NodeToTriplesMapBase {
    public BunchMap bunchMap = new HashedBunchMap();
    protected int size = 0;
    protected final Triple.Field indexField;
    protected final Triple.Field f2;
    protected final Triple.Field f3;

    public NodeToTriplesMapBase(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        this.indexField = indexField;
        this.f2 = f2;
        this.f3 = f3;
    }

    public abstract boolean add(Triple var1);

    public abstract boolean remove(Triple var1);

    public abstract ExtendedIterator<Triple> iterator(Object var1, HashCommon.NotifyEmpty var2);

    public abstract boolean contains(Triple var1);

    public abstract boolean containsBySameValueAs(Triple var1);

    public final Iterator<Object> domain() {
        return this.bunchMap.keyIterator();
    }

    protected final Object getIndexField(Triple t2) {
        return this.indexField.getField(t2).getIndexingValue();
    }

    public void clear() {
        this.bunchMap.clear();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void removedOneViaIterator() {
        --this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public abstract ExtendedIterator<Triple> iterator(Node var1, Node var2, Node var3);

    public abstract ExtendedIterator<Triple> iteratorForIndexed(Object var1);

    public ExtendedIterator<Triple> iterateAll() {
        return new NiceIterator<Triple>(){
            private final Iterator<TripleBunch> bunchIterator;
            private Iterator<Triple> current;
            private NotifyMe emptier;
            {
                this.bunchIterator = NodeToTriplesMapBase.this.bunchMap.iterator();
                this.current = NullIterator.instance();
                this.emptier = new NotifyMe();
            }

            @Override
            public Triple next() {
                if (!this.hasNext()) {
                    this.noElements("NodeToTriples iterator");
                }
                return this.current.next();
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext()) {
                    if (!this.bunchIterator.hasNext()) {
                        return false;
                    }
                    this.current = this.bunchIterator.next().iterator(this.emptier);
                }
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super Triple> action) {
                if (this.current != null) {
                    this.current.forEachRemaining(action);
                }
                this.bunchIterator.forEachRemaining((? super E next) -> {
                    this.current = next.iterator();
                    this.current.forEachRemaining(action);
                });
            }

            @Override
            public void remove() {
                this.current.remove();
            }

            class NotifyMe
            implements HashCommon.NotifyEmpty {
                NotifyMe() {
                }

                @Override
                public void emptied() {
                    bunchIterator.remove();
                }
            }
        };
    }

    public Stream<Triple> streamAll() {
        return StreamSupport.stream(this.bunchMap.spliterator(), false).flatMap(bunch -> StreamSupport.stream(bunch.spliterator(), false));
    }

    public Stream<Triple> stream(Node index, Node n2, Node n3) {
        Object indexValue = index.getIndexingValue();
        TripleBunch s2 = this.bunchMap.get(indexValue);
        if (s2 == null) {
            return Stream.empty();
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        return filter.hasFilter() ? StreamSupport.stream(s2.spliterator(), false).filter(filter.getFilter()) : StreamSupport.stream(s2.spliterator(), false);
    }

    public boolean containsMatch(Node index, Node n2, Node n3) {
        TripleBunch s2 = this.bunchMap.get(index.getIndexingValue());
        if (s2 == null) {
            return false;
        }
        FieldFilter filter = FieldFilter.filterOn(this.f2, n2, this.f3, n3);
        if (!filter.hasFilter()) {
            return true;
        }
        Spliterator<Triple> spliterator = s2.spliterator();
        boolean[] found = new boolean[]{false};
        Consumer<Triple> tester = triple -> {
            found[0] = filter.getFilter().test((Triple)triple);
        };
        while (!found[0] && spliterator.tryAdvance(tester)) {
        }
        return found[0];
    }
}

