/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.util.IteratorCollection;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphUtil {
    private static final boolean OldStyle = true;
    private static final int sliceSize = 1000;
    private static int MIN_SRC_SIZE = 1000;
    private static int MAX_SRC_SIZE = 1000000;
    private static int DST_SRC_RATIO = 2;
    private static final int CMP_GREATER = 1;
    private static final int CMP_EQUAL = 0;
    private static final int CMP_LESS = -1;

    private GraphUtil() {
    }

    public static ExtendedIterator<Node> listSubjects(Graph g2, Node p, Node o) {
        ExtendedIterator<Triple> iter = g2.find(Node.ANY, p, o);
        Set<Node> nodes = iter.mapWith(t2 -> t2.getSubject()).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static ExtendedIterator<Node> listPredicates(Graph g2, Node s2, Node o) {
        ExtendedIterator<Triple> iter = g2.find(s2, Node.ANY, o);
        Set<Node> nodes = iter.mapWith(t2 -> t2.getPredicate()).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static ExtendedIterator<Node> listObjects(Graph g2, Node s2, Node p) {
        ExtendedIterator<Triple> iter = g2.find(s2, p, Node.ANY);
        Set<Node> nodes = iter.mapWith(t2 -> t2.getObject()).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static boolean containsNode(Graph graph, Node node) {
        return graph.contains(node, Node.ANY, Node.ANY) || graph.contains(Node.ANY, Node.ANY, node) || graph.contains(Node.ANY, node, Node.ANY);
    }

    public static ExtendedIterator<Triple> findAll(Graph g2) {
        return g2.find();
    }

    public static void add(Graph graph, Triple[] triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g2 = (GraphWithPerform)graph;
            for (Triple t2 : triples) {
                g2.performAdd(t2);
            }
            graph.getEventManager().notifyAddArray(graph, triples);
        } else {
            for (Triple t3 : triples) {
                graph.add(t3);
            }
        }
    }

    public static void add(Graph graph, List<Triple> triples) {
        GraphUtil.addIteratorWorkerDirect(graph, triples.iterator());
        if (graph instanceof GraphWithPerform) {
            graph.getEventManager().notifyAddList(graph, triples);
        }
    }

    public static void add(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            List<Triple> s2 = IteratorCollection.iteratorToList(it);
            GraphUtil.addIteratorWorkerDirect(graph, s2.iterator());
            graph.getEventManager().notifyAddIterator(graph, s2);
        } else {
            GraphUtil.addIteratorWorker(graph, it);
        }
    }

    public static void addInto(Graph dstGraph, Graph srcGraph) {
        if (dstGraph == srcGraph && !dstGraph.getEventManager().listening()) {
            return;
        }
        dstGraph.getPrefixMapping().setNsPrefixes(srcGraph.getPrefixMapping());
        GraphUtil.addIteratorWorker(dstGraph, GraphUtil.findAll(srcGraph));
        dstGraph.getEventManager().notifyAddGraph(dstGraph, srcGraph);
    }

    private static void addIteratorWorker(Graph graph, Iterator<Triple> it) {
        List<Triple> s2 = IteratorCollection.iteratorToList(it);
        GraphUtil.addIteratorWorkerDirect(graph, s2.iterator());
    }

    private static void addIteratorWorkerDirect(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g2 = (GraphWithPerform)graph;
            it.forEachRemaining(g2::performAdd);
        } else {
            it.forEachRemaining(graph::add);
        }
    }

    private static boolean requireEvents(Graph graph) {
        return graph.getEventManager().listening();
    }

    public static void delete(Graph graph, Triple[] triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g2 = (GraphWithPerform)graph;
            for (Triple t2 : triples) {
                g2.performDelete(t2);
            }
            graph.getEventManager().notifyDeleteArray(graph, triples);
        } else {
            for (Triple t3 : triples) {
                graph.delete(t3);
            }
        }
    }

    public static void delete(Graph graph, List<Triple> triples) {
        GraphUtil.deleteIteratorWorkerDirect(graph, triples.iterator());
        if (graph instanceof GraphWithPerform) {
            graph.getEventManager().notifyDeleteList(graph, triples);
        }
    }

    public static void delete(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            List<Triple> s2 = IteratorCollection.iteratorToList(it);
            GraphUtil.deleteIteratorWorkerDirect(graph, s2.iterator());
            graph.getEventManager().notifyDeleteIterator(graph, s2);
        } else {
            GraphUtil.deleteIteratorWorker(graph, it);
        }
    }

    public static void remove(Graph g2, Node s2, Node p, Node o) {
        int len;
        Triple[] array = new Triple[1000];
        do {
            ExtendedIterator<Triple> iter = g2.find(s2, p, o);
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = (Triple)iter.next();
            }
            for (int i = 0; i < len; ++i) {
                g2.delete(array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
    }

    public static void deleteLoopSrc(Graph dstGraph, Graph srcGraph) {
        GraphUtil.deleteIteratorWorker(dstGraph, GraphUtil.findAll(srcGraph));
        dstGraph.getEventManager().notifyDeleteGraph(dstGraph, srcGraph);
    }

    public static void deleteLoopDst(Graph dstGraph, Graph srcGraph) {
        int dstSize = dstGraph.size();
        ArrayList<Triple> toBeDeleted = new ArrayList<Triple>(dstSize);
        ExtendedIterator<Triple> iter = GraphUtil.findAll(dstGraph);
        while (iter.hasNext()) {
            Triple t2 = (Triple)iter.next();
            if (!srcGraph.contains(t2)) continue;
            toBeDeleted.add(t2);
        }
        GraphUtil.deleteIteratorWorkerDirect(dstGraph, toBeDeleted.iterator());
        dstGraph.getEventManager().notifyDeleteGraph(dstGraph, srcGraph);
    }

    private static void deleteIteratorWorker(Graph graph, Iterator<Triple> it) {
        List<Triple> s2 = IteratorCollection.iteratorToList(it);
        GraphUtil.deleteIteratorWorkerDirect(graph, s2.iterator());
    }

    private static void deleteIteratorWorkerDirect(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g2 = (GraphWithPerform)graph;
            it.forEachRemaining(g2::performDelete);
        } else {
            it.forEachRemaining(graph::delete);
        }
    }

    public static void deleteFrom(Graph dstGraph, Graph srcGraph) {
        boolean events = GraphUtil.requireEvents(dstGraph);
        if (dstGraph == srcGraph && !events) {
            dstGraph.clear();
            return;
        }
        boolean loopOnSrc = GraphUtil.decideHowtoExecute(dstGraph, srcGraph);
        if (loopOnSrc) {
            GraphUtil.deleteLoopSrc(dstGraph, srcGraph);
            return;
        }
        GraphUtil.deleteLoopDst(dstGraph, srcGraph);
    }

    private static boolean decideHowtoExecute(Graph dstGraph, Graph srcGraph) {
        return GraphUtil.decideHowtoExecuteBySizeStep(dstGraph, srcGraph);
    }

    private static boolean decideHowtoExecuteBySizeSize(Graph dstGraph, Graph srcGraph) {
        int srcSize = srcGraph.size();
        if (srcSize <= MIN_SRC_SIZE) {
            return true;
        }
        int dstSize = dstGraph.size();
        boolean loopOnSrc = srcSize <= MIN_SRC_SIZE || dstSize > DST_SRC_RATIO * srcSize;
        return loopOnSrc;
    }

    private static boolean decideHowtoExecuteBySizeStep(Graph dstGraph, Graph srcGraph) {
        int srcSize = srcGraph.size();
        if (srcSize <= MIN_SRC_SIZE) {
            return true;
        }
        boolean loopOnSrc = srcSize <= MIN_SRC_SIZE || GraphUtil.compareSizeTo(dstGraph, DST_SRC_RATIO * srcSize) == 1;
        return loopOnSrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int compareSizeTo(Graph graph, int size) {
        try (ExtendedIterator<Triple> it = graph.find();){
            int stepsTake = Iter.step(it, size);
            if (stepsTake < size) {
                int n = -1;
                return n;
            }
            if (!it.hasNext()) {
                int n = 0;
                return n;
            }
            int n = 1;
            return n;
        }
    }
}

