/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Convert;
import org.apache.jena.util.iterator.ExtendedIterator;

public class FusekiNetLib {
    public static ContentType getContentType(HttpServletRequest request) {
        String contentTypeHeader = request.getContentType();
        if (contentTypeHeader == null) {
            return null;
        }
        return ContentType.create(contentTypeHeader);
    }

    public static Lang getLangFromAction(HttpAction action, Lang dft) {
        String contentTypeHeader = action.getRequestContentType();
        if (contentTypeHeader == null) {
            return dft;
        }
        return RDFLanguages.contentTypeToLang(contentTypeHeader);
    }

    public static String getAccept(HttpServletRequest httpRequest) {
        Enumeration<String> en = httpRequest.getHeaders("Accept");
        if (!en.hasMoreElements()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String sep = "";
        while (en.hasMoreElements()) {
            String x = en.nextElement();
            sb.append(sep);
            sep = ", ";
            sb.append(x);
        }
        return sb.toString();
    }

    public static String fmtRequest(HttpServletRequest request) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm(request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm(tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static MultiValuedMap<String, String> parseQueryString(HttpServletRequest req) {
        ListValuedMap<String, String> map = MultiMapUtils.newListValuedHashMap();
        if (req.getQueryString() != null) {
            String[] params = req.getQueryString().split("&");
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put(name, value);
            }
        }
        return map;
    }

    public static String safeParameter(HttpServletRequest request, String pName) {
        String value = request.getParameter(pName);
        if (value == null) {
            return null;
        }
        value = value.replace("\r", "");
        value = value.replace("\n", "");
        return value;
    }

    public static void addDataInto(Graph data, DatasetGraph dsg, Node graphName) {
        if (graphName == null) {
            graphName = Quad.defaultGraphNodeGenerated;
        }
        ExtendedIterator<Triple> iter = data.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t2 = (Triple)iter.next();
            dsg.add(graphName, t2.getSubject(), t2.getPredicate(), t2.getObject());
        }
        PrefixMapping pmapSrc = data.getPrefixMapping();
        PrefixMapping pmapDest = dsg.getDefaultGraph().getPrefixMapping();
        pmapDest.setNsPrefixes(pmapSrc);
    }

    public static void addDataInto(DatasetGraph src, DatasetGraph dest) {
        Iterator<Quad> iter = src.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Quad q = iter.next();
            dest.add(q);
        }
        PrefixMapping pmapSrc = src.getDefaultGraph().getPrefixMapping();
        PrefixMapping pmapDest = dest.getDefaultGraph().getPrefixMapping();
        pmapDest.withDefaultMappings(pmapSrc);
    }
}

