/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.GSP_Base;
import org.apache.jena.fuseki.servlets.GraphTarget;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.OperationDeniedException;
import org.apache.jena.sparql.core.DatasetGraph;

public class GSP_R
extends GSP_Base {
    @Override
    protected void doGet(HttpAction action) {
        if (GSP_R.isQuads(action)) {
            this.execGetQuads(action);
        } else {
            this.execGetGSP(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execGetQuads(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        MediaType mediaType = ActionLib.contentNegotationQuads(action);
        try {
            ServletOutputStream output = action.getResponseOutputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            Object output = null;
        }
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentTypeStr());
        if (lang == null) {
            lang = RDFLanguages.TRIG;
        }
        if (action.verbose) {
            action.log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentTypeStr(), mediaType.getCharset(), lang.getName()));
        }
        if (!RDFLanguages.isQuads(lang)) {
            ServletOps.errorBadRequest("Not a quads format: " + mediaType);
        }
        action.beginRead();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            try {
                ActionLib.datasetResponse(action, dsg, lang);
                ServletOps.success(action);
            }
            catch (OperationDeniedException ex) {
                throw ex;
            }
            catch (JenaException ex) {
                ServletOps.error(406, "Failed to write output: " + ex.getMessage());
            }
        }
        finally {
            action.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execGetGSP(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        MediaType mediaType = ActionLib.contentNegotationRDF(action);
        try {
            ServletOutputStream output = action.getResponseOutputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            Object output = null;
        }
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentTypeStr());
        if (lang == null) {
            lang = RDFLanguages.TURTLE;
        }
        action.beginRead();
        if (action.verbose) {
            action.log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentTypeStr(), mediaType.getCharset(), lang.getName()));
        }
        try {
            boolean exists;
            DatasetGraph dsg = this.decideDataset(action);
            GraphTarget target = GraphTarget.determineTargetGSP(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("GET->" + target);
            }
            if (!(exists = target.exists())) {
                ServletOps.errorNotFound("No such graph: " + target.label());
            }
            Graph graph = target.graph();
            try {
                ActionLib.graphResponse(action, graph, lang);
                ServletOps.success(action);
            }
            catch (OperationDeniedException ex) {
                throw ex;
            }
            catch (JenaException ex) {
                ServletOps.error(406, "Failed to write output: " + ex.getMessage());
            }
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,HEAD,OPTIONS");
        ServletOps.success(action);
    }

    @Override
    protected void doHead(HttpAction action) {
        if (GSP_R.isQuads(action)) {
            this.execHeadQuads(action);
        } else {
            this.execHeadGSP(action);
        }
    }

    protected void execHeadQuads(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        MediaType mediaType = ActionLib.contentNegotationQuads(action);
        if (action.verbose) {
            action.log.info(String.format("[%d]   Head: Content-Type=%s", action.id, mediaType.getContentTypeStr()));
        }
        ServletOps.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execHeadGSP(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        MediaType mediaType = ActionLib.contentNegotationRDF(action);
        if (action.verbose) {
            action.log.info(String.format("[%d]   Head: Content-Type=%s", action.id, mediaType.getContentTypeStr()));
        }
        action.beginRead();
        try {
            boolean exists;
            DatasetGraph dsg = this.decideDataset(action);
            GraphTarget target = GraphTarget.determineTargetGSP(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("HEAD->" + target);
            }
            if (!(exists = target.exists())) {
                ServletOps.errorNotFound("No such graph: " + target.label());
            }
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        ServletOps.errorMethodNotAllowed("POST : Read-only");
    }

    @Override
    protected void doDelete(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE : Read-only");
    }

    @Override
    protected void doPut(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PUT : Read-only");
    }

    @Override
    protected void doPatch(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PATCH : Read-only");
    }
}

