/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.server.FusekiVocab;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;
import org.apache.jena.rdf.model.Resource;

public class Operation {
    private static String NS = FusekiVocab.NS;
    private static Map<Node, Operation> mgr = new HashMap<Node, Operation>();
    public static final Operation Query = Operation.alloc(FusekiVocab.opQuery.asNode(), "query", "SPARQL Query");
    public static final Operation Update = Operation.alloc(FusekiVocab.opUpdate.asNode(), "update", "SPARQL Update");
    public static final Operation GSP_R = Operation.alloc(FusekiVocab.opGSP_r.asNode(), "gsp-r", "Graph Store Protocol (Read)");
    public static final Operation GSP_RW = Operation.alloc(FusekiVocab.opGSP_rw.asNode(), "gsp-rw", "Graph Store Protocol");
    public static final Operation Shacl = Operation.alloc(FusekiVocab.opShacl.asNode(), "SHACL", "SHACL Validation");
    public static final Operation Upload = Operation.alloc(FusekiVocab.opUpload.asNode(), "upload", "File Upload");
    public static final Operation Patch = Operation.alloc(FusekiVocab.opPatch.asNode(), "patch", "RDF Patch");
    public static final Operation NoOp = Operation.alloc(FusekiVocab.opNoOp.asNode(), "no-op", "No Op");
    private final Node id;
    private final String name;
    private final String jsName;
    private final String description;

    public static Operation get(Node node) {
        return mgr.get(node);
    }

    public static Operation alloc(String iriStr, String name, String description) {
        try {
            IRIx iri2 = IRIx.create(iriStr);
            if (!iri2.isReference()) {
                Log.warn(Operation.class, "Poor Operation name: " + iriStr + " : Relative IRI");
            }
        }
        catch (IRIException ex) {
            Log.error(Operation.class, "Poor Operation name: " + iriStr + " : Not an IRI");
        }
        Node node = NodeFactory.createURI(iriStr);
        return Operation.alloc(node, name, description);
    }

    public static Operation alloc(Node op, String name, String description) {
        return mgr.computeIfAbsent(op, x -> Operation.create(x, name, description));
    }

    private static Operation create(Node id, String shortName, String description) {
        return new Operation(id, shortName, Lib.lowercase(shortName), description);
    }

    private Operation(Node fullName, String name, String jsName, String description) {
        this.id = fullName;
        this.name = name;
        this.jsName = jsName;
        this.description = description;
    }

    public Node getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getJsonName() {
        return this.jsName;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return this.name;
    }

    private static void altName(Resource altName, Resource properName) {
        Operation.altName(altName.asNode(), properName.asNode());
    }

    private static void altName(Node altName, Node properName) {
        Operation op = mgr.get(properName);
        mgr.put(altName, op);
    }

    static {
        Operation.altName(FusekiVocab.opNoOp_alt, FusekiVocab.opNoOp);
        Operation.altName(FusekiVocab.opGSP_r_alt, FusekiVocab.opGSP_r);
        Operation.altName(FusekiVocab.opGSP_rw_alt, FusekiVocab.opGSP_rw);
    }
}

