/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.simple;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Match;

public class StorageTuplesN {
    private Set<Tuple<Node>> tuples = new HashSet<Tuple<Node>>();
    public final int N;

    public StorageTuplesN(int N2) {
        this.N = N2;
    }

    public void add(Tuple<Node> terms) {
        this.check(terms);
        this.tuples.add(terms);
    }

    public void delete(Tuple<Node> terms) {
        this.check(terms);
        this.tuples.remove(terms);
    }

    public void removeAll(Tuple<Node> pattern) {
        List<Tuple<Node>> acc = ListUtils.toList(this.find(pattern));
        acc.stream().forEach(this::delete);
    }

    public Stream<Tuple<Node>> find(Tuple<Node> pattern) {
        this.check(pattern);
        return this.tuples.stream().filter(t2 -> this.match((Tuple<Node>)t2, pattern));
    }

    public boolean contain(Tuple<Node> terms) {
        this.check(terms);
        return this.tuples.contains(terms);
    }

    private boolean match(Tuple<Node> terms, Tuple<Node> pattern) {
        for (int i = 0; i < terms.len(); ++i) {
            if (Match.match(terms.get(i), pattern.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean match(Node node, Node pattern) {
        return Match.match(node, pattern);
    }

    private void check(Tuple<Node> terms) {
        if (terms.len() != this.N) {
            throw new IllegalArgumentException("Length " + terms.len() + " : expected " + this.N);
        }
    }
}

