/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Objects;

public class ClassPathUtils {
    public static String packageToPath(String path) {
        return Objects.requireNonNull(path, "path").replace('.', '/');
    }

    public static String pathToPackage(String path) {
        return Objects.requireNonNull(path, "path").replace('/', '.');
    }

    public static String toFullyQualifiedName(Class<?> context2, String resourceName) {
        Objects.requireNonNull(context2, "context");
        Objects.requireNonNull(resourceName, "resourceName");
        return ClassPathUtils.toFullyQualifiedName(context2.getPackage(), resourceName);
    }

    public static String toFullyQualifiedName(Package context2, String resourceName) {
        Objects.requireNonNull(context2, "context");
        Objects.requireNonNull(resourceName, "resourceName");
        return context2.getName() + "." + resourceName;
    }

    public static String toFullyQualifiedPath(Class<?> context2, String resourceName) {
        Objects.requireNonNull(context2, "context");
        Objects.requireNonNull(resourceName, "resourceName");
        return ClassPathUtils.toFullyQualifiedPath(context2.getPackage(), resourceName);
    }

    public static String toFullyQualifiedPath(Package context2, String resourceName) {
        Objects.requireNonNull(context2, "context");
        Objects.requireNonNull(resourceName, "resourceName");
        return ClassPathUtils.packageToPath(context2.getName()) + "/" + resourceName;
    }
}

