/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.jakarta;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.JakartaServletRequestContext;

public class JakartaServletFileUpload<I extends FileItem<I>, F extends FileItemFactory<I>>
extends AbstractFileUpload<HttpServletRequest, I, F> {
    private static final String POST_METHOD = "POST";

    public static final boolean isMultipartContent(HttpServletRequest request) {
        return POST_METHOD.equalsIgnoreCase(request.getMethod()) && AbstractFileUpload.isMultipartContent(new JakartaServletRequestContext(request));
    }

    public JakartaServletFileUpload() {
    }

    public JakartaServletFileUpload(F fileItemFactory) {
        this.setFileItemFactory(fileItemFactory);
    }

    @Override
    public FileItemInputIterator getItemIterator(HttpServletRequest request) throws FileUploadException, IOException {
        return super.getItemIterator(new JakartaServletRequestContext(request));
    }

    @Override
    public Map<String, List<I>> parseParameterMap(HttpServletRequest request) throws FileUploadException {
        return this.parseParameterMap(new JakartaServletRequestContext(request));
    }

    @Override
    public List<I> parseRequest(HttpServletRequest request) throws FileUploadException {
        return this.parseRequest(new JakartaServletRequestContext(request));
    }
}

