/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene40.blocktree;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.backward_codecs.lucene40.blocktree.FieldReader;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.Outputs;

public final class Lucene40BlockTreeTermsReader
extends FieldsProducer {
    static final Outputs<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = FST_OUTPUTS.getNoOutput();
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final String TERMS_EXTENSION = "tim";
    static final String TERMS_CODEC_NAME = "BlockTreeTermsDict";
    public static final int VERSION_START = 3;
    public static final int VERSION_META_LONGS_REMOVED = 4;
    public static final int VERSION_COMPRESSED_SUFFIXES = 5;
    public static final int VERSION_META_FILE = 6;
    public static final int VERSION_CURRENT = 6;
    static final String TERMS_INDEX_EXTENSION = "tip";
    static final String TERMS_INDEX_CODEC_NAME = "BlockTreeTermsIndex";
    static final String TERMS_META_EXTENSION = "tmd";
    static final String TERMS_META_CODEC_NAME = "BlockTreeTermsMeta";
    final IndexInput termsIn;
    final IndexInput indexIn;
    final PostingsReaderBase postingsReader;
    private final Map<String, FieldReader> fieldMap;
    private final List<String> fieldList;
    final String segment;
    final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene40BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        boolean success = false;
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        try {
            long termsLength;
            long indexLength;
            HashMap<String, FieldReader> fieldMap;
            block34: {
                String termsName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_EXTENSION);
                this.termsIn = EndiannessReverserUtil.openInput(state.directory, termsName, state.context);
                this.version = CodecUtil.checkIndexHeader(this.termsIn, TERMS_CODEC_NAME, 3, 6, state.segmentInfo.getId(), state.segmentSuffix);
                String indexName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_INDEX_EXTENSION);
                this.indexIn = EndiannessReverserUtil.openInput(state.directory, indexName, state.context);
                CodecUtil.checkIndexHeader(this.indexIn, TERMS_INDEX_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                if (this.version < 6) {
                    postingsReader.init(this.termsIn, state);
                    CodecUtil.retrieveChecksum(this.indexIn);
                    CodecUtil.retrieveChecksum(this.termsIn);
                }
                String metaName = IndexFileNames.segmentFileName(this.segment, state.segmentSuffix, TERMS_META_EXTENSION);
                fieldMap = null;
                Throwable priorE = null;
                indexLength = -1L;
                termsLength = -1L;
                try (ChecksumIndexInput metaIn = this.version >= 6 ? EndiannessReverserUtil.openChecksumInput(state.directory, metaName, state.context) : null;){
                    block33: {
                        try {
                            IndexInput indexMetaIn;
                            IndexInput termsMetaIn;
                            if (this.version >= 6) {
                                CodecUtil.checkIndexHeader(metaIn, TERMS_META_CODEC_NAME, this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                                indexMetaIn = termsMetaIn = metaIn;
                                postingsReader.init(metaIn, state);
                            } else {
                                Lucene40BlockTreeTermsReader.seekDir(this.termsIn);
                                Lucene40BlockTreeTermsReader.seekDir(this.termsIn);
                                Lucene40BlockTreeTermsReader.seekDir(this.indexIn);
                                indexMetaIn = this.indexIn;
                                termsMetaIn = this.termsIn;
                            }
                            int numFields = termsMetaIn.readVInt();
                            if (numFields < 0) {
                                throw new CorruptIndexException("invalid numFields: " + numFields, termsMetaIn);
                            }
                            fieldMap = CollectionUtil.newHashMap(numFields);
                            for (int i = 0; i < numFields; ++i) {
                                int longsSize;
                                int field = termsMetaIn.readVInt();
                                long numTerms = termsMetaIn.readVLong();
                                if (numTerms <= 0L) {
                                    throw new CorruptIndexException("Illegal numTerms for field number: " + field, termsMetaIn);
                                }
                                BytesRef rootCode = Lucene40BlockTreeTermsReader.readBytesRef(termsMetaIn);
                                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                                if (fieldInfo == null) {
                                    throw new CorruptIndexException("invalid field number: " + field, termsMetaIn);
                                }
                                long sumTotalTermFreq = termsMetaIn.readVLong();
                                long sumDocFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? sumTotalTermFreq : termsMetaIn.readVLong();
                                int docCount = termsMetaIn.readVInt();
                                if (this.version < 4 && (longsSize = termsMetaIn.readVInt()) < 0) {
                                    throw new CorruptIndexException("invalid longsSize for field: " + fieldInfo.name + ", longsSize=" + longsSize, termsMetaIn);
                                }
                                BytesRef minTerm = Lucene40BlockTreeTermsReader.readBytesRef(termsMetaIn);
                                BytesRef maxTerm = Lucene40BlockTreeTermsReader.readBytesRef(termsMetaIn);
                                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), termsMetaIn);
                                }
                                if (sumDocFreq < (long)docCount) {
                                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, termsMetaIn);
                                }
                                if (sumTotalTermFreq < sumDocFreq) {
                                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, termsMetaIn);
                                }
                                long indexStartFP = indexMetaIn.readVLong();
                                FieldReader previous = fieldMap.put(fieldInfo.name, new FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, indexMetaIn, this.indexIn, minTerm, maxTerm));
                                if (previous == null) continue;
                                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, termsMetaIn);
                            }
                            if (this.version >= 6) {
                                indexLength = metaIn.readLong();
                                termsLength = metaIn.readLong();
                            }
                            if (metaIn == null) break block33;
                        }
                        catch (Throwable exception) {
                            try {
                                priorE = exception;
                                break block34;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (metaIn != null) {
                                    CodecUtil.checkFooter(metaIn, priorE);
                                } else if (priorE != null) {
                                    IOUtils.rethrowAlways(priorE);
                                }
                            }
                        }
                        CodecUtil.checkFooter(metaIn, priorE);
                        break block34;
                    }
                    if (priorE != null) {
                        IOUtils.rethrowAlways(priorE);
                    }
                }
            }
            if (this.version >= 6) {
                CodecUtil.retrieveChecksum(this.indexIn, indexLength);
                CodecUtil.retrieveChecksum(this.termsIn, termsLength);
            } else {
                assert (indexLength == -1L) : indexLength;
                assert (termsLength == -1L) : termsLength;
            }
            ArrayList fieldList = new ArrayList(fieldMap.keySet());
            fieldList.sort(null);
            this.fieldMap = fieldMap;
            this.fieldList = Collections.unmodifiableList(fieldList);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(new Closeable[]{this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        int numBytes = in.readVInt();
        if (numBytes < 0) {
            throw new CorruptIndexException("invalid bytes length: " + numBytes, in);
        }
        BytesRef bytes = new BytesRef();
        bytes.length = numBytes;
        bytes.bytes = new byte[numBytes];
        in.readBytes(bytes.bytes, 0, numBytes);
        return bytes;
    }

    private static void seekDir(IndexInput input) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        long offset = input.readLong();
        input.seek(offset);
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.indexIn, this.termsIn, this.postingsReader);
        }
        finally {
            this.fieldMap.clear();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.fieldList.iterator();
    }

    @Override
    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fieldMap.get(field);
    }

    @Override
    public int size() {
        return this.fieldMap.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t2) {
            return b.toString();
        }
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.indexIn);
        CodecUtil.checksumEntireFile(this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fieldMap.size() + ",delegate=" + this.postingsReader + ")";
    }
}

