/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fi;

import org.apache.lucene.analysis.util.StemmerUtil;

public class FinnishLightStemmer {
    public int stem(char[] s2, int len) {
        if (len < 4) {
            return len;
        }
        block4: for (int i = 0; i < len; ++i) {
            switch (s2[i]) {
                case '\u00e4': 
                case '\u00e5': {
                    s2[i] = 97;
                    continue block4;
                }
                case '\u00f6': {
                    s2[i] = 111;
                }
            }
        }
        len = this.step1(s2, len);
        len = this.step2(s2, len);
        len = this.step3(s2, len);
        len = this.norm1(s2, len);
        len = this.norm2(s2, len);
        return len;
    }

    private int step1(char[] s2, int len) {
        if (len > 8) {
            if (StemmerUtil.endsWith(s2, len, "kin")) {
                return this.step1(s2, len - 3);
            }
            if (StemmerUtil.endsWith(s2, len, "ko")) {
                return this.step1(s2, len - 2);
            }
        }
        if (len > 11) {
            if (StemmerUtil.endsWith(s2, len, "dellinen")) {
                return len - 8;
            }
            if (StemmerUtil.endsWith(s2, len, "dellisuus")) {
                return len - 9;
            }
        }
        return len;
    }

    private int step2(char[] s2, int len) {
        if (len > 5) {
            if (StemmerUtil.endsWith(s2, len, "lla") || StemmerUtil.endsWith(s2, len, "tse") || StemmerUtil.endsWith(s2, len, "sti")) {
                return len - 3;
            }
            if (StemmerUtil.endsWith(s2, len, "ni")) {
                return len - 2;
            }
            if (StemmerUtil.endsWith(s2, len, "aa")) {
                return len - 1;
            }
        }
        return len;
    }

    private int step3(char[] s2, int len) {
        if (len > 8) {
            if (StemmerUtil.endsWith(s2, len, "nnen")) {
                s2[len - 4] = 115;
                return len - 3;
            }
            if (StemmerUtil.endsWith(s2, len, "ntena")) {
                s2[len - 5] = 115;
                return len - 4;
            }
            if (StemmerUtil.endsWith(s2, len, "tten")) {
                return len - 4;
            }
            if (StemmerUtil.endsWith(s2, len, "eiden")) {
                return len - 5;
            }
        }
        if (len > 6) {
            if (StemmerUtil.endsWith(s2, len, "neen") || StemmerUtil.endsWith(s2, len, "niin") || StemmerUtil.endsWith(s2, len, "seen") || StemmerUtil.endsWith(s2, len, "teen") || StemmerUtil.endsWith(s2, len, "inen")) {
                return len - 4;
            }
            if (s2[len - 3] == 'h' && this.isVowel(s2[len - 2]) && s2[len - 1] == 'n') {
                return len - 3;
            }
            if (StemmerUtil.endsWith(s2, len, "den")) {
                s2[len - 3] = 115;
                return len - 2;
            }
            if (StemmerUtil.endsWith(s2, len, "ksen")) {
                s2[len - 4] = 115;
                return len - 3;
            }
            if (StemmerUtil.endsWith(s2, len, "ssa") || StemmerUtil.endsWith(s2, len, "sta") || StemmerUtil.endsWith(s2, len, "lla") || StemmerUtil.endsWith(s2, len, "lta") || StemmerUtil.endsWith(s2, len, "tta") || StemmerUtil.endsWith(s2, len, "ksi") || StemmerUtil.endsWith(s2, len, "lle")) {
                return len - 3;
            }
        }
        if (len > 5) {
            if (StemmerUtil.endsWith(s2, len, "na") || StemmerUtil.endsWith(s2, len, "ne")) {
                return len - 2;
            }
            if (StemmerUtil.endsWith(s2, len, "nei")) {
                return len - 3;
            }
        }
        if (len > 4) {
            if (StemmerUtil.endsWith(s2, len, "ja") || StemmerUtil.endsWith(s2, len, "ta")) {
                return len - 2;
            }
            if (s2[len - 1] == 'a') {
                return len - 1;
            }
            if (s2[len - 1] == 'n' && this.isVowel(s2[len - 2])) {
                return len - 2;
            }
            if (s2[len - 1] == 'n') {
                return len - 1;
            }
        }
        return len;
    }

    private int norm1(char[] s2, int len) {
        if (len > 5 && StemmerUtil.endsWith(s2, len, "hde")) {
            s2[len - 3] = 107;
            s2[len - 2] = 115;
            s2[len - 1] = 105;
        }
        if (len > 4 && (StemmerUtil.endsWith(s2, len, "ei") || StemmerUtil.endsWith(s2, len, "at"))) {
            return len - 2;
        }
        if (len > 3) {
            switch (s2[len - 1]) {
                case 'a': 
                case 'e': 
                case 'i': 
                case 'j': 
                case 's': 
                case 't': {
                    return len - 1;
                }
            }
        }
        return len;
    }

    private int norm2(char[] s2, int len) {
        if (len > 8 && (s2[len - 1] == 'e' || s2[len - 1] == 'o' || s2[len - 1] == 'u')) {
            --len;
        }
        if (len > 4) {
            if (s2[len - 1] == 'i') {
                --len;
            }
            if (len > 4) {
                char ch = s2[0];
                for (int i = 1; i < len; ++i) {
                    if (s2[i] == ch && (ch == 'k' || ch == 'p' || ch == 't')) {
                        len = StemmerUtil.delete(s2, i--, len);
                        continue;
                    }
                    ch = s2[i];
                }
            }
        }
        return len;
    }

    private boolean isVowel(char ch) {
        switch (ch) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'y': {
                return true;
            }
        }
        return false;
    }
}

