/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.tupletable;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.sys.SystemTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleTable
implements Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(TupleTable.class);
    private final TupleIndex[] indexes;
    private final TupleIndex scanAllIndex;
    private final int tupleLen;
    private boolean syncNeeded = false;

    public TupleTable(int tupleLen, TupleIndex[] indexes) {
        this.tupleLen = tupleLen;
        this.indexes = indexes;
        if (indexes[0] == null) {
            throw new TDBException("TupleTable: no primary index");
        }
        for (TupleIndex index : indexes) {
            if (index == null || index.getTupleLength() == tupleLen) continue;
            throw new TDBException("Incompatible index: " + index.getMappingStr());
        }
        this.scanAllIndex = TupleTable.chooseScanAllIndex(tupleLen, indexes);
    }

    private static TupleIndex chooseScanAllIndex(int tupleLen, TupleIndex[] indexes) {
        if (tupleLen != 4) {
            return indexes[0];
        }
        for (TupleIndex index : indexes) {
            if (!index.getName().equals("SPOG")) continue;
            return index;
        }
        for (TupleIndex index : indexes) {
            if (!index.getName().endsWith("G")) continue;
            return index;
        }
        Log.warn(SystemTDB.errlog, "Did not find a ???G index for full scans");
        return indexes[0];
    }

    public boolean add(Tuple<NodeId> t2) {
        if (this.tupleLen != t2.len()) {
            throw new TDBException(String.format("Mismatch: inserting tuple of length %d into a table of tuples of length %d", t2.len(), this.tupleLen));
        }
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] == null) continue;
            if (!this.indexes[i].add(t2)) {
                if (i == 0) {
                    this.duplicate(t2);
                    return false;
                }
                this.unexpectedDuplicate(t2, i);
                throw new TDBException(String.format("Secondary index duplicate: %s -> %s", this.indexes[i].getMappingStr(), t2));
            }
            this.syncNeeded = true;
        }
        return true;
    }

    protected void duplicate(Tuple<NodeId> t2) {
    }

    protected void unexpectedDuplicate(Tuple<NodeId> t2, int i) {
    }

    public boolean delete(Tuple<NodeId> t2) {
        if (this.tupleLen != t2.len()) {
            throw new TDBException(String.format("Mismatch: deleting tuple of length %d from a table of tuples of length %d", t2.len(), this.tupleLen));
        }
        boolean rc = false;
        for (TupleIndex index : this.indexes) {
            if (index == null || !(rc = index.delete(t2))) continue;
            this.syncNeeded = true;
        }
        return rc;
    }

    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> pattern) {
        if (this.tupleLen != pattern.len()) {
            throw new TDBException(String.format("Mismatch: finding tuple of length %d in a table of tuples of length %d", pattern.len(), this.tupleLen));
        }
        int numSlots = 0;
        for (int i = 0; i < this.tupleLen; ++i) {
            NodeId x = pattern.get(i);
            if (NodeId.isAny(x)) continue;
            ++numSlots;
        }
        if (numSlots == 0) {
            return this.scanAllIndex.all();
        }
        int indexNumSlots = 0;
        TupleIndex index = null;
        for (TupleIndex idx : this.indexes) {
            int w;
            if (idx == null || (w = idx.weight(pattern)) <= indexNumSlots) continue;
            indexNumSlots = w;
            index = idx;
        }
        if (index == null) {
            index = this.indexes[0];
        }
        return index.find(pattern);
    }

    @Override
    public final void close() {
        for (TupleIndex idx : this.indexes) {
            if (idx == null) continue;
            idx.close();
        }
    }

    @Override
    public void sync() {
        if (this.syncNeeded) {
            for (TupleIndex idx : this.indexes) {
                if (idx == null) continue;
                idx.sync();
            }
            this.syncNeeded = false;
        }
    }

    public boolean isEmpty() {
        return this.indexes[0].isEmpty();
    }

    public void clear() {
        for (TupleIndex idx : this.indexes) {
            if (idx == null) continue;
            idx.clear();
        }
        this.syncNeeded = true;
    }

    public long size() {
        return this.indexes[0].size();
    }

    public TupleIndex getIndex(int i) {
        return this.indexes[i];
    }

    public TupleIndex[] getIndexes() {
        return this.indexes;
    }

    public int getTupleLen() {
        return this.tupleLen;
    }

    public void setTupleIndex(int i, TupleIndex index) {
        if (index != null && index.getTupleLength() != this.tupleLen) {
            throw new TDBException("Incompatible index: " + index.getMappingStr());
        }
        this.indexes[i] = index;
    }

    public int numIndexes() {
        return this.indexes.length;
    }
}

