/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecBuilderAdapter;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class QueryExecutionBuilderAdapter
implements QueryExecutionBuilder {
    private final QueryExecBuilder builder;

    public QueryExecutionBuilderAdapter(QueryExecBuilder builder) {
        this.builder = builder;
    }

    public static QueryExecutionBuilder adapt(QueryExecBuilder builder) {
        Objects.requireNonNull(builder);
        QueryExecutionBuilder result = builder instanceof QueryExecBuilderAdapter ? ((QueryExecBuilderAdapter)builder).getExecBuilder() : new QueryExecutionBuilderAdapter(builder);
        return result;
    }

    public QueryExecBuilder getExecBuilder() {
        return this.builder;
    }

    @Override
    public QueryExecutionBuilderAdapter query(Query query2) {
        this.builder.query(query2);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter query(String queryString) {
        this.builder.query(queryString);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter query(String queryString, Syntax syntax) {
        this.builder.query(queryString, syntax);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter set(Symbol symbol, Object value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter set(Symbol symbol, boolean value) {
        this.builder.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter context(Context context2) {
        this.builder.context(context2);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter substitution(QuerySolution querySolution) {
        if (querySolution != null) {
            Binding binding = BindingLib.toBinding(querySolution);
            this.builder.substitution(binding);
        }
        return this;
    }

    public QueryExecutionBuilderAdapter substitution(Binding binding) {
        this.builder.substitution(binding);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter substitution(String varName, RDFNode value) {
        Var var = Var.alloc(varName);
        Node val = value.asNode();
        this.builder.substitution(var, val);
        return this;
    }

    @Override
    public QueryExecutionBuilderAdapter timeout(long value, TimeUnit timeUnit) {
        this.builder.timeout(value, timeUnit);
        return this;
    }

    @Override
    public QueryExecution build() {
        return QueryExecutionAdapter.adapt(this.builder.build());
    }
}

