/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.other.RDFDataException;
import org.apache.jena.shacl.Imports;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetType;
import org.apache.jena.shacl.engine.Targets;
import org.apache.jena.shacl.engine.constraint.JLogConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ConstraintComponents;
import org.apache.jena.shacl.parser.Constraints;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.parser.TargetExtensions;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.sys.ShaclSystem;
import org.apache.jena.shacl.validation.Severity;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ShapesParser {
    private static final boolean DEBUG = false;
    private static IndentedWriter OUT = IndentedWriter.stdout;
    private static Set<RDFDatatype> decimalCompatible = new HashSet<RDFDatatype>();

    public static Targets targets(Graph shapesGraph) {
        return Targets.create(shapesGraph);
    }

    public static Map<Node, Shape> parseShapes(Graph shapesGraph, Targets targets) {
        ConstraintComponents sparqlConstraintComponents = ConstraintComponents.parseSparqlConstraintComponents(shapesGraph);
        TargetExtensions targetExtensions = TargetExtensions.parseSPARQLTargetType(shapesGraph);
        return ShapesParser.parseShapes(shapesGraph, targets, sparqlConstraintComponents, targetExtensions);
    }

    public static Collection<Node> findDeclaredShapes(Graph shapesGraph) {
        HashSet<Node> declared = new HashSet<Node>();
        G.allNodesOfTypeRDFS(shapesGraph, SHACL.NodeShape).forEach(declared::add);
        G.allNodesOfTypeRDFS(shapesGraph, SHACL.PropertyShape).forEach(declared::add);
        return declared;
    }

    public static ParserResult parseProcess(Graph shapesGraph, Collection<Node> declaredNodes) {
        Targets targets = ShapesParser.targets(shapesGraph);
        ConstraintComponents sparqlConstraintComponents = ConstraintComponents.parseSparqlConstraintComponents(shapesGraph);
        TargetExtensions targetExtensions = TargetExtensions.parseSPARQLTargetType(shapesGraph);
        Map<Node, Shape> shapesMap = ShapesParser.parseShapes(shapesGraph, targets, sparqlConstraintComponents, targetExtensions);
        Collection rootShapes = shapesMap.values().stream().filter(sh -> sh.hasTarget()).collect(Collectors.toUnmodifiableList());
        ArrayList<Shape> declShapes = new ArrayList<Shape>();
        declaredNodes.forEach(shapeNode -> {
            if (!shapesMap.containsKey(shapeNode)) {
                Shape shape = ShapesParser.parseShape(shapesMap, shapesGraph, shapeNode);
                declShapes.add(shape);
            }
        });
        rootShapes.forEach(sh -> {
            if (declShapes.contains(sh)) {
                System.err.println("Shape in both: " + sh);
            }
            if (!sh.hasTarget()) {
                System.err.println("Root shape with no target: " + sh);
            }
        });
        declShapes.forEach(sh -> {
            if (sh.hasTarget()) {
                System.err.println("Declared shape with target: " + sh);
            }
        });
        Pair<Node, List<Node>> pair = Imports.baseAndImports(shapesGraph);
        Node shapesBase = pair.getLeft();
        List<Node> imports = pair.getRight();
        ParserResult x = new ParserResult(shapesBase, imports, shapesMap, targets, rootShapes, declShapes, sparqlConstraintComponents, targetExtensions);
        return x;
    }

    private static Map<Node, Shape> parseShapes(Graph shapesGraph, Targets targets, ConstraintComponents sparqlConstraintComponents, TargetExtensions targetExtensions) {
        HashMap<Node, Shape> shapesMap = new HashMap<Node, Shape>();
        LinkedHashMap<Node, Shape> acc = new LinkedHashMap<Node, Shape>();
        for (Node shapeNode : targets.targetNodes) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : targets.targetClasses) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : targets.targetObjectsOf) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : targets.targetSubjectsOf) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : targets.implicitClassTargets) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        for (Node shapeNode : targets.targetExtension) {
            ShapesParser.parseShapeAcc(acc, shapesMap, shapesGraph, shapeNode);
        }
        if (sparqlConstraintComponents != null && !sparqlConstraintComponents.hasParameters()) {
            shapesMap.values().forEach(shape -> {
                List<Constraint> x = ConstraintComponents.processShape(shapesGraph, sparqlConstraintComponents, shape);
                if (x != null && !x.isEmpty()) {
                    shape.getConstraints().addAll(x);
                }
            });
        }
        return shapesMap;
    }

    private static Shape parseShapeAcc(Map<Node, Shape> acc, Map<Node, Shape> shapesMap, Graph shapesGraph, Node shNode) {
        if (acc.containsKey(shNode)) {
            return acc.get(shNode);
        }
        Shape shape = ShapesParser.parseShape(shapesMap, shapesGraph, shNode);
        if (acc != null) {
            acc.put(shNode, shape);
        }
        return shape;
    }

    public static Shape parseShape(Map<Node, Shape> shapesMap, Graph shapesGraph, Node shNode) {
        HashSet<Node> traversed = new HashSet<Node>();
        Shape shape = ShapesParser.parseShapeStep(traversed, shapesMap, shapesGraph, shNode);
        return shape;
    }

    static Shape unshape(Graph shapesGraph, Node shapeNode) {
        return new NodeShape(shapesGraph, shapeNode, false, Severity.Violation, Collections.emptySet(), Collections.emptySet(), Collections.singleton(new JLogConstraint("Cycle")), Collections.emptySet());
    }

    static Shape parseShapeStep(Set<Node> traversed, Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        try {
            if (parsed.containsKey(shapeNode)) {
                return parsed.get(shapeNode);
            }
            if (traversed.contains(shapeNode)) {
                ShaclSystem.systemShaclLogger.warn("Cycle detected : node " + ShLib.displayStr(shapeNode));
                return ShapesParser.unshape(shapesGraph, shapeNode);
            }
            traversed.add(shapeNode);
            Shape shape = ShapesParser.parseShape$(traversed, parsed, shapesGraph, shapeNode);
            parsed.put(shapeNode, shape);
            traversed.remove(shapeNode);
            return shape;
        }
        catch (RDFDataException ex) {
            throw new ShaclParseException(ex.getMessage());
        }
    }

    private static Shape parseShape$(Set<Node> traversed, Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        boolean isDeactivated = G.contains(shapesGraph, shapeNode, SHACL.deactivated, NodeConst.nodeTrue);
        Collection<Target> targets = ShapesParser.targets(shapesGraph, shapeNode);
        List<Constraint> constraints = Constraints.parseConstraints(shapesGraph, shapeNode, parsed, traversed);
        Severity severity = ShapesParser.severity(shapesGraph, shapeNode);
        List<Node> messages = G.listSP(shapesGraph, shapeNode, SHACL.message);
        List<PropertyShape> propertyShapes = ShapesParser.findPropertyShapes(traversed, parsed, shapesGraph, shapeNode);
        boolean isPropertyShape = G.contains(shapesGraph, shapeNode, SHACL.path, Node.ANY);
        if (!isPropertyShape) {
            return new NodeShape(shapesGraph, shapeNode, isDeactivated, severity, messages, targets, constraints, propertyShapes);
        }
        Node pathNode = G.getOneSP(shapesGraph, shapeNode, SHACL.path);
        Path path = ShapesParser.parsePath(shapesGraph, pathNode);
        List<Node> names = G.listSP(shapesGraph, shapeNode, SHACL.name);
        List<Node> descriptions = G.listSP(shapesGraph, shapeNode, SHACL.description);
        List<Node> groups = G.listSP(shapesGraph, shapeNode, SHACL.group);
        Node defaultValue = G.getZeroOrOneSP(shapesGraph, shapeNode, SHACL.defaultValue);
        Node order = G.getZeroOrOneSP(shapesGraph, shapeNode, SHACL.order);
        if (order != null && !ShapesParser.isDecimalCompatible(order)) {
            throw new ShaclParseException("Not an xsd:decimal for sh:order");
        }
        return new PropertyShape(shapesGraph, shapeNode, isDeactivated, severity, messages, targets, path, constraints, propertyShapes);
    }

    private static boolean isDecimalCompatible(Node node) {
        try {
            RDFDatatype dt = node.getLiteralDatatype();
            return decimalCompatible.contains(dt);
        }
        catch (JenaException ex) {
            return false;
        }
    }

    private static Path parsePath(Graph shapesGraph, Node node) {
        return ShaclPaths.parsePath(shapesGraph, node);
    }

    private static List<PropertyShape> findPropertyShapes(Set<Node> traversed, Map<Node, Shape> parsed, Graph shapesGraph, Node shapeNode) {
        List<Triple> propertyTriples = G.find(shapesGraph, shapeNode, SHACL.property, null).toList();
        ArrayList<PropertyShape> propertyShapes = new ArrayList<PropertyShape>();
        for (Triple t2 : propertyTriples) {
            Node propertyShape = G.object(t2);
            long x = G.countSP(shapesGraph, propertyShape, SHACL.path);
            if (x == 0L) {
                boolean existsAsSubject = G.contains(shapesGraph, propertyShape, null, null);
                if (!existsAsSubject) {
                    throw new ShaclParseException("Missing property shape: node=" + ShLib.displayStr(shapeNode) + " sh:property " + ShLib.displayStr(propertyShape));
                }
                throw new ShaclParseException("No sh:path on a property shape: node=" + ShLib.displayStr(shapeNode) + " sh:property " + ShLib.displayStr(propertyShape));
            }
            if (x > 1L) {
                List<Node> paths = G.listSP(shapesGraph, propertyShape, SHACL.path);
                throw new ShaclParseException("Multiple sh:path on a property shape: " + ShLib.displayStr(shapeNode) + " sh:property" + ShLib.displayStr(propertyShape) + " : " + paths);
            }
            PropertyShape ps = (PropertyShape)ShapesParser.parseShapeStep(traversed, parsed, shapesGraph, propertyShape);
            propertyShapes.add(ps);
        }
        return propertyShapes;
    }

    private static Collection<Target> targets(Graph shapesGraph, Node shape) {
        ArrayList<Target> x = new ArrayList<Target>();
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetNode);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetClass);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetObjectsOf);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetSubjectsOf);
        ShapesParser.accTarget(x, shapesGraph, shape, TargetType.targetExtension);
        if (ShapesParser.isShapeType(shapesGraph, shape) && G.isOfType(shapesGraph, shape, C.rdfsClass)) {
            x.add(Target.create(shape, TargetType.implicitClass, shape, null));
        }
        return x;
    }

    private static boolean isShapeType(Graph shapesGraph, Node shape) {
        return G.hasType(shapesGraph, shape, SHACL.NodeShape) || G.hasType(shapesGraph, shape, SHACL.PropertyShape);
    }

    private static Severity severity(Graph shapesGraph, Node shNode) {
        Node sev = G.getSP(shapesGraph, shNode, SHACL.severity);
        if (sev == null) {
            return Severity.Violation;
        }
        return Severity.create(sev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void accTarget(Collection<Target> acc, Graph shapesGraph, Node shape, TargetType targetType) {
        Graph graph;
        ExtendedIterator<Triple> iter = shapesGraph.find(shape, targetType.predicate, null);
        switch (targetType) {
            case targetExtension: {
                graph = shapesGraph;
                break;
            }
            default: {
                graph = null;
            }
        }
        try {
            iter.mapWith(triple -> Target.create(triple.getSubject(), targetType, triple.getObject(), graph)).forEachRemaining(target -> acc.add((Target)target));
        }
        finally {
            iter.close();
        }
    }

    static {
        decimalCompatible.add(XSDDatatype.XSDdecimal);
        decimalCompatible.add(XSDDatatype.XSDinteger);
        decimalCompatible.add(XSDDatatype.XSDlong);
        decimalCompatible.add(XSDDatatype.XSDint);
    }

    public static class ParserResult {
        public final Node shapesBase;
        public final List<Node> imports;
        public final Map<Node, Shape> shapesMap;
        public final Targets targets;
        public final Collection<Shape> rootShapes;
        public final Collection<Shape> declaredShapes;
        public final ConstraintComponents sparqlConstraintComponents;
        public final TargetExtensions targetExtensions;

        ParserResult(Node shapesBase, List<Node> imports, Map<Node, Shape> shapesMap, Targets targets, Collection<Shape> rootShapes, Collection<Shape> declaredShapes, ConstraintComponents sparqlConstraintComponents, TargetExtensions targetExtensions) {
            this.shapesBase = shapesBase;
            this.imports = imports;
            this.shapesMap = shapesMap;
            this.targets = targets;
            this.rootShapes = rootShapes;
            this.declaredShapes = declaredShapes;
            this.sparqlConstraintComponents = sparqlConstraintComponents;
            this.targetExtensions = targetExtensions;
        }
    }

    static class ParserState {
        Targets rootShapes;
        ConstraintComponents sparqlConstraintComponents;
        Map<Node, Shape> shapesMap;

        ParserState() {
        }
    }
}

